/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.el.utils;

import org.mule.munit.common.el.MunitExpressionFunction;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.FunctionParameter;

import java.util.Collections;
import java.util.List;

/**
 * Returns the same payload in a mock
 */
public class SamePayloadFunction extends MunitExpressionFunction {

  @Override
  public Object call(Object[] objects, BindingContext bindingContext) {
    return new SamePayload();
  }

  @Override
  public String getName() {
    return "samePayload";
  }

  @Override
  public List<FunctionParameter> parameters() {
    return Collections.emptyList();
  }
}
