/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.interceptor.matchers;


/**
 * <p>
 * Matcher to match a specified class.
 * </p>
 * <p/>
 * <p>
 * Usage ex.: <code>new AnyClassMatcher(String.class).match("hello);</code> Will return true
 * </p>
 * <p>
 * Usage ex.: <code>new AnyClassMatcher(Integer.class).match("hello); </code> Will return false
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class AnyClassMatcher implements Matcher {

  /**
   * <p>
   * The wanted class.
   * </p>
   */
  private Class expectedClass;

  public AnyClassMatcher(Class expectedClass) {
    this.expectedClass = expectedClass;
  }

  /**
   * @see Matcher#match(Object)
   */
  @Override
  public boolean match(Object o) {
    if (o == null) {
      return false;
    }
    return this.expectedClass.isAssignableFrom(o.getClass());
  }
}
