/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.interceptor.matchers;

/**
 * <p>
 * Equality matcher. It compares using the equal method of Object
 * </p>
 * <p/>
 * Usage: <code>new EqMatcher("desired").match("desired");</code> will return true.
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class EqMatcher implements Matcher {

  /**
   * <p>The expected object</p>
   */
  private Object expected;

  public EqMatcher(Object expected) {
    this.expected = expected;
  }

  /**
   * @see Matcher#match(Object)
   */
  @Override
  public boolean match(Object o) {
    if (o == null) {
      return false;
    }
    return o.equals(expected);
  }
}
