/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.interceptor.matchers;

/**
 * <p>
 * Utility class to create Matchers
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.4.0
 */
public class Matchers {

  public static Matcher any(Class type) {
    return new AnyClassMatcher(type);
  }

  public static Matcher isNull() {
    return new NullMatcher();
  }

  public static Matcher isNotNull() {
    return new NotNullMatcher();
  }

  public static Matcher contains(String value) {
    return new RegexMatcher(".*" + value + ".*");
  }

  public static Matcher matches(String regex) {
    return new RegexMatcher(regex);
  }
}
