/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.interceptor.matchers.mel;

import org.mule.munit.common.interceptor.matchers.AnyClassMatcher;
import org.mule.munit.common.interceptor.matchers.DumbMatcher;
import org.mule.runtime.core.api.el.ExpressionLanguageContext;
import org.mule.runtime.core.api.el.ExpressionLanguageFunction;

/**
 * MEL function for the MUnit {@link org.mule.munit.common.interceptor.matchers.AnyClassMatcher}
 *
 * Usage:
 * 
 * <pre>
 *         {@code
 *           <mock:verify-call processor="jira:create-group" atLeast="1">
 *                   <mock:attributes>
 *                           <mock:attribute name="userName" whereValue-ref='#[any()]'/>
 *                   </mock:attributes>
 *           </mock:verify-call>
 *         }
 * </pre>
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class AnyClassMatcherFunction implements ExpressionLanguageFunction {

  @Override
  public Object call(final Object[] params, ExpressionLanguageContext context) {
    if (params == null || params.length == 0) {
      return new DumbMatcher(false);
    }
    if (params[0] instanceof Class) {
      return new AnyClassMatcher((Class) params[0]);
    }
    return new DumbMatcher(false);

  }
}
