/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.interceptor.matchers.mel;

import org.mule.munit.common.interceptor.matchers.DumbMatcher;
import org.mule.munit.common.interceptor.matchers.RegexMatcher;
import org.mule.runtime.core.api.el.ExpressionLanguageContext;
import org.mule.runtime.core.api.el.ExpressionLanguageFunction;

/**
 * Contains Function based on {@link RegexMatcher}
 * 
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class ContainsMatcherFunction implements ExpressionLanguageFunction {

  @Override
  public Object call(final Object[] params, ExpressionLanguageContext context) {
    if (params == null || params.length == 0 || !(params[0] instanceof String)) {
      return new DumbMatcher(false);
    }
    return new RegexMatcher(".*" + params[0] + ".*");
  }
}
