/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.interceptor.matchers.mel;

// TODO be ware this is not api package
import org.mule.munit.common.interceptor.matchers.DumbMatcher;
import org.mule.munit.common.interceptor.matchers.RegexMatcher;
import org.mule.runtime.core.api.el.ExpressionLanguageContext;
import org.mule.runtime.core.api.el.ExpressionLanguageFunction;

/**
 * MEL function for {@link RegexMatcher}
 * 
 * Usage:
 * 
 * <pre>
 *         {@code
 *
 *           <script:script name="mockPayload" engine="groovy"><![CDATA[ return new String("anotherString"); ]]>
 *           </script:script>
 *
 *           <mock:verify-call processor="jira:create-group" atLeast="1">
 *                   <mock:attributes>
 *                           <mock:attribute name="userName" whereValue-ref='#[matchesRegex('any.*')]'/>
 *                   </mock:attributes>
 *           </mock:verify-call>
 *         }
 * </pre>
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class RegexMatcherFunction implements ExpressionLanguageFunction {

  @Override
  public Object call(final Object[] params, ExpressionLanguageContext context) {
    if (params == null || params.length == 0 || !(params[0] instanceof String)) {
      return new DumbMatcher(false);
    }
    return new RegexMatcher((String) params[0]);
  }
}
