/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.model;

import static org.mule.runtime.api.meta.ExpressionSupport.REQUIRED;

import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public class EventError {

  @Parameter
  @Optional
  @Placement(order = 0)
  private String typeId;
  @Parameter
  @Optional
  @Placement(order = 1)
  @Expression(REQUIRED)
  private Throwable cause;

  public String getTypeId() {
    return typeId;
  }

  public Object getCause() {
    return cause;
  }

  public void setTypeId(String id) {
    this.typeId = id;
  }

  public void setCause(Object cause) {
    this.cause = (Throwable) cause;
  }
}
