package org.mule.munit.common.protocol.listeners;

/**
 * Classes implementing this interface handle the notification of a complete run.
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public interface RemoteRunEventListener {

  default void notifyRunStart() {}

  default void notifyRunFinish() {}

  default void notifyContainerFailure(String suite, String stackTrace) {}

  default void notifyCoverageReport(String coverageReportJson) {}

  default void notifyUnexpectedError(String stackTrace) {}

  default void notifyUnknown(String message) {}
}
