/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.behavior;

import java.util.HashMap;
import java.util.Map;
import org.mule.munit.common.behavior.ProcessorId;
import org.mule.munit.common.interceptor.matchers.Matcher;
import org.mule.runtime.api.meta.NamedObject;

public class ProcessorCall {
    private ProcessorId processorId;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public ProcessorCall(ProcessorId processorId) {
        this.processorId = processorId;
    }

    public ProcessorId getProcessorId() {
        return this.processorId;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public boolean isCallOf(ProcessorId id) {
        return this.processorId.equals(id);
    }

    public int matchingWeight(ProcessorCall call) {
        if (this.processorId.getFullName().equals(call.getProcessorId().getFullName()) || call.getProcessorId().getName().matches(this.processorId.getName()) && call.getProcessorId().getNamespace().matches(this.processorId.getNamespace())) {
            Map<String, Object> callAttributes = call.getAttributes();
            for (Map.Entry<String, Object> myAttribute : this.attributes.entrySet()) {
                if (this.callHasAttribute(callAttributes, myAttribute)) continue;
                return -1;
            }
            return this.attributes.size();
        }
        return -1;
    }

    private boolean callHasAttribute(Map<String, Object> callAttributes, Map.Entry<String, Object> myAttribute) {
        String myAttributeKey = myAttribute.getKey();
        return callAttributes.containsKey(myAttributeKey) && (this.matchAttributeValue(callAttributes.get(myAttributeKey), myAttribute.getValue()) || this.matchAttributeName(callAttributes.get(myAttributeKey), myAttribute.getValue()));
    }

    private boolean matchAttributeValue(Object value, Object matcher) {
        if (matcher == null) {
            return value == null;
        }
        if (matcher instanceof Matcher) {
            return ((Matcher)matcher).match(value);
        }
        return matcher.equals(value);
    }

    private boolean matchAttributeName(Object value, Object matcher) {
        if (value instanceof NamedObject) {
            return this.matchAttributeValue(((NamedObject)value).getName(), matcher);
        }
        return false;
    }
}

