/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.el.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.mule.munit.common.el.utils.ReusableByteArrayInputStream;
import org.mule.munit.common.util.IOUtils;

public class MunitResource {
    static Logger logger = Logger.getLogger(MunitResource.class);
    private String path;

    public MunitResource(String path) {
        this.path = path;
    }

    public InputStream asStream() {
        InputStream streamImput = this.getClass().getClassLoader().getResourceAsStream(this.path);
        if (streamImput == null) {
            throw new IllegalArgumentException("The path provided to get the resource does not exist");
        }
        return streamImput;
    }

    public String asString() {
        try {
            return IOUtils.toString((InputStream)this.asStream());
        }
        catch (IOException ioe) {
            logger.error((Object)"The file is corrupted");
            return null;
        }
    }

    public byte[] asByteArray() {
        byte[] byteArrayImput = null;
        try {
            byteArrayImput = IOUtils.toByteArray((InputStream)this.asStream());
        }
        catch (IOException ioe) {
            logger.error((Object)"The file is corrupted");
        }
        return byteArrayImput;
    }

    public InputStream asReusableStream() {
        InputStream streamInput = this.asStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)streamInput, (OutputStream)baos);
        }
        catch (IOException e) {
            logger.error((Object)"The file is corrupted");
        }
        return new ReusableByteArrayInputStream(baos.toByteArray());
    }
}

