/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.el.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ReusableByteArrayInputStream
extends ByteArrayInputStream {
    public ReusableByteArrayInputStream(byte[] buf) {
        super(buf);
        this.mark(-1);
    }

    public ReusableByteArrayInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
        this.mark(-1);
    }

    @Override
    public synchronized int read() {
        int read = super.read();
        this.resetIfEnd(read);
        return read;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        int read = super.read(b, off, len);
        this.resetIfEnd(read);
        return read;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.reset();
    }

    private void resetIfEnd(int read) {
        if (-1 == read) {
            this.reset();
        }
    }
}

