/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.properties;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.common.properties.MUnitUserPropertiesManager;
import org.mule.munit.common.util.IOUtils;

public class ApplicationPropertyLoader {
    public static final String DEFAULT_APP_PROPERTIES_RESOURCE = "mule-app.properties";
    private transient Log log = LogFactory.getLog(this.getClass());
    private MUnitUserPropertiesManager propertiesManager;

    public ApplicationPropertyLoader(MUnitUserPropertiesManager propertiesManager, Log log) {
        this.log = log;
        this.propertiesManager = propertiesManager;
    }

    public void loadAndSetApplicationProperties(URL resourceUrl) {
        if (resourceUrl == null) {
            this.log.warn((Object)"mule-app.properties file was not found");
            return;
        }
        try {
            Map<String, String> appPropsMap = this.loadApplicationProperties(resourceUrl);
            this.setApplicationProperties(appPropsMap);
        }
        catch (IOException e) {
            this.log.warn((Object)"mule-app.properties could not be loaded.");
        }
    }

    private Map<String, String> loadApplicationProperties(URL appPropsFile) throws IOException {
        HashMap<String, String> appPropsMap = new HashMap<String, String>();
        Properties props = IOUtils.toProperties(appPropsFile);
        for (Object key : props.keySet()) {
            appPropsMap.put(key.toString(), props.getProperty(key.toString()));
        }
        return appPropsMap;
    }

    private void setApplicationProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (MUnitUserPropertiesManager.hasSystemProperty(entry.getKey())) continue;
            if (MUnitUserPropertiesManager.hasEnvironmentProperty(entry.getKey())) continue;
            this.propertiesManager.addApplicationProperty(entry.getKey(), entry.getValue());
            this.log.debug((Object)("System property [" + entry.getKey() + "] set to: [" + entry.getValue() + "]"));
        }
    }
}

