/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.protocol.listeners;

import java.util.ArrayList;
import java.util.List;
import org.mule.munit.common.protocol.listeners.RemoteRunEventListener;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.message.TestStatus;

public class RunEventListenerContainer
implements RunEventListener {
    private List<RunEventListener> runEventListeners = new ArrayList<RunEventListener>();

    @Override
    public void notifyRunStart() {
        this.runEventListeners.forEach(RemoteRunEventListener::notifyRunStart);
    }

    @Override
    public void notifyContainerFailure(String suite, String stackTrace) {
        this.runEventListeners.forEach(l -> l.notifyContainerFailure(suite, stackTrace));
    }

    @Override
    public void notifySuiteStart(String suite, int numberOfTests) {
        this.runEventListeners.forEach(l -> l.notifySuiteStart(suite, numberOfTests));
    }

    @Override
    public void notifyBeforeSuiteStart(String name) {
        this.runEventListeners.forEach(l -> l.notifyBeforeSuiteStart(name));
    }

    @Override
    public void notifyBeforeSuiteEnd(String name, String stackTrace, TestStatus status) {
        this.runEventListeners.forEach(l -> l.notifyBeforeSuiteEnd(name, stackTrace, status));
    }

    @Override
    public void notifyTestStart(String name) {
        this.runEventListeners.forEach(l -> l.notifyTestStart(name));
    }

    @Override
    public void notifyTestEnd(String name, String stackTrace, TestStatus status, long elapsedTime) {
        this.runEventListeners.forEach(l -> l.notifyTestEnd(name, stackTrace, status, elapsedTime));
    }

    @Override
    public void notifyAfterSuiteStart(String name) {
        this.runEventListeners.forEach(l -> l.notifyAfterSuiteStart(name));
    }

    @Override
    public void notifyAfterSuiteEnd(String name, String stackTrace, TestStatus status) {
        this.runEventListeners.forEach(l -> l.notifyAfterSuiteEnd(name, stackTrace, status));
    }

    @Override
    public void notifySuiteEnd(String suite, long elapsedTime) {
        this.runEventListeners.forEach(l -> l.notifySuiteEnd(suite, elapsedTime));
    }

    @Override
    public void notifyCoverageReport(String coverageReportJson) {
        this.runEventListeners.forEach(l -> l.notifyCoverageReport(coverageReportJson));
    }

    @Override
    public void notifyRunFinish() {
        this.runEventListeners.forEach(RemoteRunEventListener::notifyRunFinish);
    }

    @Override
    public void notifyUnexpectedError(String stackTrace) {
        this.runEventListeners.forEach(l -> l.notifyUnexpectedError(stackTrace));
    }

    @Override
    public void notifySuiteUnexpectedError(String stackTrace) {
        this.runEventListeners.forEach(l -> l.notifySuiteUnexpectedError(stackTrace));
    }

    public void addNotificationListener(RunEventListener listener) {
        this.runEventListeners.add(listener);
    }
}

