/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.util;

import org.mule.munit.common.exception.MunitError;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;

public class MunitExpressionWrapper {
    private ExtendedExpressionManager expressionManager;

    public MunitExpressionWrapper(ExtendedExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    public ExtendedExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public TypedValue evaluateIfExpression(Event event, Object source) {
        if (this.isExpression(source)) {
            return this.evaluate(event, source);
        }
        return new TypedValue(source, null);
    }

    public TypedValue evaluate(Event muleEvent, Object source) {
        this.validate(source);
        String stringSource = (String)source;
        return this.expressionManager.evaluate(stringSource, muleEvent);
    }

    public boolean isExpression(Object source) {
        return null != source && source instanceof String && this.expressionManager.isExpression((String)source);
    }

    public boolean isExpressionValid(Object source) {
        if (!String.class.isAssignableFrom(source.getClass())) {
            return false;
        }
        String exp = (String)source;
        return this.expressionManager.isExpression(exp) && this.expressionManager.isValid(exp);
    }

    public void validate(Object expression) {
        if (expression instanceof String) {
            ValidationResult validationResult = this.expressionManager.validate((String)expression);
            if (!validationResult.isSuccess()) {
                throw new MunitError("Expression parsing failed. The expression: '" + expression + "' is invalid - " + validationResult.errorMessage());
            }
        } else {
            throw new MunitError("Expression parsing failed. The expression: '" + expression + "' is invalid (not a string)");
        }
    }

    public String evaluateNotNullString(Event event, Object expression, String name) {
        String result = this.evaluateAsStringIfExpression(event, expression, name);
        if (result == null) {
            throw new MunitError(String.format("%s '%s' should not be null", name, expression));
        }
        return result;
    }

    public String evaluateAsStringIfExpression(Event event, Object expression) {
        return this.evaluateAsStringIfExpression(event, expression, "Expression");
    }

    public String evaluateAsStringIfExpression(Event event, Object expression, String name) {
        try {
            return (String)this.evaluateIfExpression(event, expression).getValue();
        }
        catch (ClassCastException e) {
            throw new MunitError(String.format("%s '%s' should be evaluated as a String", name, expression), e);
        }
    }
}

