/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.util;

import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.munit.common.exception.MunitError;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.execution.MessageProcessorExecutionTemplate;

public class MunitUtils {
    public static final String MUNIT_TEST_FLOW_NAME = "appleFlow";

    public static void verifyAssertions(Event event, List<Processor> assertions) {
        if (assertions == null || assertions.isEmpty()) {
            return;
        }
        for (Processor processor : assertions) {
            try {
                MessageProcessorExecutionTemplate.createExecutionTemplate().execute(processor, event);
            }
            catch (Exception e) {
                MunitUtils.throwRootCauseIfMatches(e);
                throw new RuntimeException(e);
            }
        }
    }

    public static void throwRootCauseIfMatches(Exception e) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
        if (null != rootCause) {
            if (AssertionError.class.isAssignableFrom(rootCause.getClass())) {
                throw (Error)ExceptionUtils.getRootCause((Throwable)e);
            }
            if (MunitError.class.isAssignableFrom(rootCause.getClass())) {
                throw (Error)ExceptionUtils.getRootCause((Throwable)e);
            }
        }
    }
}

