/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.el;

import org.hamcrest.Matcher;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;

import java.util.Optional;

/**
 * <p>
 * Abstract class that represents an Expression Language function
 * </p>
 * <p/>
 * <p>
 * This class contains a method to implement the function name, and delegates de 'call' method
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 4.0
 */
public abstract class MunitExpressionFunction implements ExpressionFunction {

  @Override
  public Optional<DataType> returnType() {
    return Optional.of(DataType.fromType(Matcher.class));
  }

  public TypedValue asTypedValue() {
    return new TypedValue<>(this, DataType.fromFunction(this));
  }

  /**
   * Returns the name to bind with this function
   *
   * @return The name of the function
   */
  public abstract String getName();
}
