/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.el.utils;

/**
 * <p>
 * Function to return a resource as a byte array
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class GetResourceAsByteArrayFunction extends GetResourceFunction {

  @Override
  public String getName() {
    return "getResourceAsByteArray";
  }

  @Override
  protected Object handleResource(MunitResource munitResource) {
    return munitResource.asByteArray();
  }
}
