/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.el.utils;

import java.util.Collections;
import java.util.List;

import org.mule.munit.common.el.MunitExpressionFunction;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;

/**
 * This is an extension that picks an indicated file, an returns its content in the payload of the message from where the method
 * was called. The type of the returned value can be String, InputStream or byte array, depending of the operation aplicated to
 * the MunitResource returned
 *
 * <pre>
 *         {@code
 *
 *           <mock:verify-call processor="jira:create-group" atLeast="1">
 *                   <mock:attributes>
 *                           <mock:attribute name="userName" whereValue-ref='#[getResource(fileName).asString()]'/>
 *                   </mock:attributes>
 *           </mock:verify-call>
 *         }
 * </pre>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public abstract class GetResourceFunction extends MunitExpressionFunction {

  // Get the application classloader
  private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

  @Override
  public Object call(Object[] params, BindingContext bindingContext) {
    return handleResource(new MunitResource((String) params[0], classLoader));
  }

  protected abstract Object handleResource(MunitResource munitResource);

  @Override
  public List<FunctionParameter> parameters() {
    return Collections.singletonList(new FunctionParameter("resource", DataType.STRING));
  }

}
