/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.util;

import java.util.List;

import org.apache.commons.lang3.exception.ExceptionUtils;

import org.mule.munit.common.exception.MunitError;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.core.api.processor.Processor;


/**
 * Common class for common stuffs in MUnit
 *
 * Do not use this class for everything
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class MunitUtils {

  public static final String MUNIT_TEST_FLOW_NAME = "appleFlow";

  /**
   * Do not use this anymore
   * @param event
   * @param assertions
     */
  @Deprecated
  public static void verifyAssertions(Event event, List<Processor> assertions) {
    if (assertions == null || assertions.isEmpty()) {
      return;
    }

    for (Processor processor : assertions) {
      try {
        // MessageProcessorExecutionTemplate.createExecutionTemplate().execute(processor, event);
      } catch (Exception e) {
        throwRootCauseIfMatches(e);

        throw new RuntimeException(e);
      }
    }
  }

  /**
   * The method will throw the root cause of the exception if it matches a AssertionError or a MunitError. It will do nothing in
   * anyother scenario.
   *
   * @param e exception containing the root cause
   */
  public static void throwRootCauseIfMatches(Exception e) {
    Throwable rootCause = ExceptionUtils.getRootCause(e);
    if (null != rootCause) {

      if (AssertionError.class.isAssignableFrom(rootCause.getClass())) {
        throw (Error) ExceptionUtils.getRootCause(e);
      }

      if (MunitError.class.isAssignableFrom(rootCause.getClass())) {
        throw (Error) ExceptionUtils.getRootCause(e);
      }
    }
  }


}
