/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.el.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import org.mule.munit.common.el.utils.ReusableByteArrayInputStream;
import org.mule.munit.common.util.IOUtils;

public class MunitResource {
    private static Logger logger = Logger.getLogger(MunitResource.class);
    private String path;
    private ClassLoader classLoader;

    public MunitResource(String path, ClassLoader classLoader) {
        this.path = path;
        this.classLoader = classLoader;
    }

    public InputStream asStream() {
        InputStream streamInput = this.classLoader.getResourceAsStream(this.path);
        if (streamInput == null) {
            throw new IllegalArgumentException("The path provided to get the resource does not exist");
        }
        return streamInput;
    }

    public String asString() {
        try {
            return IOUtils.toString((InputStream)this.asStream(), (Charset)Charset.defaultCharset());
        }
        catch (IOException ioe) {
            logger.error((Object)"The file is corrupted");
            return null;
        }
    }

    public byte[] asByteArray() {
        byte[] byteArrayInput = null;
        try {
            byteArrayInput = IOUtils.toByteArray((InputStream)this.asStream());
        }
        catch (IOException ioe) {
            logger.error((Object)"The file is corrupted");
        }
        return byteArrayInput;
    }

    public InputStream asReusableStream() {
        InputStream streamInput = this.asStream();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)streamInput, (OutputStream)outputStream);
        }
        catch (IOException e) {
            logger.error((Object)"The file is corrupted");
        }
        return new ReusableByteArrayInputStream(outputStream.toByteArray());
    }
}

