/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.properties;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.common.util.ClassUtils;
import org.mule.munit.common.util.IOUtils;

public class MuleDeployPropertyLoader {
    public static final String DEFAULT_MULE_DEPLOY_PROPERTIES_RESOURCE = "mule-deploy.properties";
    private final File appDir;
    private transient Log log = LogFactory.getLog(this.getClass());
    private Map<String, String> domainDeployPropertiesMap = null;
    private Map<String, String> applicationDeployPropertiesMap = null;

    public MuleDeployPropertyLoader(File appDir) {
        this.appDir = appDir;
    }

    public Map<String, String> getApplicationDeployProperties() {
        if (null == this.applicationDeployPropertiesMap) {
            this.loadApplicationDeployProperties();
        }
        return this.applicationDeployPropertiesMap;
    }

    public Map<String, String> getDomainDeployProperties() {
        if (null == this.applicationDeployPropertiesMap) {
            this.loadApplicationDeployProperties();
        }
        if (null == this.domainDeployPropertiesMap) {
            String domainName = this.applicationDeployPropertiesMap.get("domain");
            this.loadDomainDeployProperties(domainName);
        }
        return this.domainDeployPropertiesMap;
    }

    private void loadApplicationDeployProperties() {
        this.applicationDeployPropertiesMap = new HashMap<String, String>();
        File deployPropertiesFile = new File(this.appDir, DEFAULT_MULE_DEPLOY_PROPERTIES_RESOURCE);
        if (deployPropertiesFile.exists()) {
            this.log.debug((Object)("Loaded mule-deploy.properties file from:" + deployPropertiesFile));
            this.loadDeployProperties(deployPropertiesFile, this.applicationDeployPropertiesMap);
        }
    }

    private void loadDomainDeployProperties(String domainName) {
        Enumeration<URL> urls;
        Optional<URL> url;
        this.domainDeployPropertiesMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)domainName)) {
            this.log.debug((Object)"Attempting to load mule-deploy.properties for a blank domain will return not properties");
        }
        if ((url = Collections.list(urls = ClassUtils.getResources(DEFAULT_MULE_DEPLOY_PROPERTIES_RESOURCE, this.getClass().getClassLoader())).stream().filter(u -> this.doesTheFileBelongToTheDomain((URL)u, domainName)).findFirst()).isPresent()) {
            this.log.debug((Object)("Loaded mule-deploy.properties file from:" + url.get().getPath()));
            this.loadDeployProperties(url.get(), this.domainDeployPropertiesMap);
        }
    }

    private void loadDeployProperties(File resourceFile, Map<String, String> propertiesMap) {
        try {
            this.loadDeployProperties(resourceFile.toURI().toURL(), propertiesMap);
        }
        catch (MalformedURLException e) {
            this.log.warn((Object)"mule-deploy.properties could not be loaded.");
        }
    }

    private void loadDeployProperties(URL resourceURL, Map<String, String> propertiesMap) {
        if (null == resourceURL) {
            this.log.warn((Object)"mule-deploy.properties file was not found");
            return;
        }
        try {
            propertiesMap.putAll(this.loadProperties(resourceURL));
        }
        catch (IOException e) {
            this.log.warn((Object)"mule-deploy.properties could not be loaded.");
        }
    }

    private boolean doesTheFileBelongToTheDomain(URL url, String domainName) {
        String domainMuleDeployPropertiesRelativePath = File.separator + domainName + File.separator;
        String path = new File(url.getPath()).getPath();
        return path.contains(domainMuleDeployPropertiesRelativePath);
    }

    private Map<String, String> loadProperties(URL propsURL) throws IOException {
        HashMap<String, String> appPropsMap = new HashMap<String, String>();
        Properties props = IOUtils.toProperties(propsURL);
        for (Object key : props.keySet()) {
            appPropsMap.put(key.toString(), props.getProperty(key.toString()));
        }
        return appPropsMap;
    }
}

