/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.event;

import java.io.Serializable;
import java.util.Map;
import javax.activation.DataHandler;
import org.mule.munit.common.event.DataTypeBuilder;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.internal.message.InternalMessage;

public class MessageBuilderDecorator {
    private InternalMessage.Builder builder;

    public MessageBuilderDecorator() {
        this.builder = (InternalMessage.Builder)InternalMessage.builder();
    }

    public MessageBuilderDecorator(Message originalMessage) {
        this.builder = InternalMessage.builder((Message)originalMessage);
    }

    public MessageBuilderDecorator withInboundProperty(String key, Serializable value) {
        MediaType mediaType = DataType.fromObject((Object)value).getMediaType();
        String mediaTypeStr = mediaType.getPrimaryType() + "/" + mediaType.getSubType();
        return this.withInboundProperty(key, value, mediaTypeStr, null);
    }

    public MessageBuilderDecorator withInboundProperty(String key, Object value, String mediaType, String charset) {
        DataType dataType = new DataTypeBuilder().value(value).encoding(charset).mediaType(mediaType).build();
        this.builder.addInboundProperty(key, (Serializable)new TypedValue(value, dataType));
        return this;
    }

    public MessageBuilderDecorator withInboundProperties(Map<String, TypedValue<Serializable>> properties) {
        if (null != properties && !properties.isEmpty()) {
            properties.forEach((k, v) -> this.builder.addInboundProperty(k, (Serializable)v.getValue(), v.getDataType()));
        }
        return this;
    }

    public MessageBuilderDecorator withOutboundProperty(String key, Serializable value) {
        MediaType mediaType = DataType.fromObject((Object)value).getMediaType();
        String mediaTypeStr = mediaType.getPrimaryType() + "/" + mediaType.getSubType();
        return this.withOutboundProperty(key, value, mediaTypeStr, null);
    }

    public MessageBuilderDecorator withOutboundProperty(String key, Object value, String mediaType, String charset) {
        DataType dataType = new DataTypeBuilder().value(value).encoding(charset).mediaType(mediaType).build();
        this.builder.addOutboundProperty(key, (Serializable)new TypedValue(value, dataType));
        return this;
    }

    public MessageBuilderDecorator withOutboundProperties(Map<String, TypedValue<Serializable>> properties) {
        if (null != properties && !properties.isEmpty()) {
            properties.forEach((k, v) -> this.builder.addOutboundProperty(k, (Serializable)v.getValue(), v.getDataType()));
        }
        return this;
    }

    public MessageBuilderDecorator withInboundAttachment(String key, DataHandler value) {
        this.builder.addInboundAttachment(key, value);
        return this;
    }

    public MessageBuilderDecorator withInboundAttachments(Map<String, DataHandler> attachments) {
        if (null != attachments && !attachments.isEmpty()) {
            attachments.forEach((k, v) -> this.builder.addInboundAttachment(k, v));
        }
        return this;
    }

    public MessageBuilderDecorator withOutboundAttachment(String key, DataHandler value) {
        this.builder.addOutboundAttachment(key, value);
        return this;
    }

    public MessageBuilderDecorator withOutboundAttachments(Map<String, DataHandler> attachments) {
        if (null != attachments && !attachments.isEmpty()) {
            attachments.forEach((k, v) -> this.builder.addOutboundAttachment(k, v));
        }
        return this;
    }

    public MessageBuilderDecorator withPayload(Object payload) {
        this.builder.value(payload);
        return this;
    }

    public MessageBuilderDecorator withMediaType(MediaType mediaType) {
        this.builder.mediaType(mediaType);
        return this;
    }

    public MessageBuilderDecorator withAttributes(Object attributes) {
        this.builder.attributes(TypedValue.of((Object)attributes));
        return this;
    }

    public Message build() {
        return this.builder.build();
    }
}

