/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.event;

import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.model.TypedKeyValue;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeParamsBuilder;

/**
 * The goal of this class is to build safely DataTypes based in different inputs, and doing the proper validations for invalid
 * values
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class DataTypeBuilder {

  private Object value;
  private String encoding;
  private String mediaType;

  public static DataTypeBuilder fromTypedKeyValue(TypedKeyValue typedKeyValue) {
    DataTypeBuilder builder = new DataTypeBuilder();
    builder.value(typedKeyValue.getValue());
    builder.encoding(typedKeyValue.getEncoding());
    builder.mediaType(typedKeyValue.getMediaType());
    return builder;
  }

  public DataType build() {
    DataTypeParamsBuilder dataTypeParamsBuilder = DataType.builder().fromObject(value);
    if (StringUtils.isNotBlank(mediaType)) {
      dataTypeParamsBuilder = dataTypeParamsBuilder.mediaType(mediaType);
    }
    dataTypeParamsBuilder = dataTypeParamsBuilder.charset(encoding);
    return dataTypeParamsBuilder.build();
  }

  public DataTypeBuilder value(Object value) {
    this.value = value;
    return this;
  }

  public DataTypeBuilder encoding(String encoding) {
    this.encoding = encoding;
    return this;
  }

  public DataTypeBuilder mediaType(String mediaType) {
    this.mediaType = mediaType;
    return this;
  }


}
