/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.model;

import java.io.IOException;

import javax.activation.DataHandler;

import org.mule.munit.common.event.DataTypeBuilder;
import org.mule.munit.common.util.IOUtils;
import org.mule.runtime.api.metadata.DataType;

/**
 * <p>
 * A model representing an Attachment
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class Attachment extends DefaultTypedKeyValue {

  public DataHandler getDataHandler() {
    DataType dataType = DataTypeBuilder.fromTypedKeyValue(this).build();
    try {
      return IOUtils.toDataHandler(getKey(), getValue(), dataType.getMediaType());
    } catch (IOException e) {
      throw new IllegalStateException("Unable to create data handler for attachment: " + getKey(), e);
    }
  }
}
