/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.protocol.listeners;

import java.util.ArrayList;
import java.util.List;

import org.mule.munit.common.protocol.message.TestStatus;

/**
 * <p>
 * A listener implementation that delegate the notifications to other listeners
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class RunEventListenerContainer implements RunEventListener {

  private List<RunEventListener> runEventListeners = new ArrayList<>();


  @Override
  public void notifyRunStart() {
    runEventListeners.forEach(RemoteRunEventListener::notifyRunStart);
  }

  @Override
  public void notifyContainerFailure(String stackTrace) {
    runEventListeners.forEach(l -> l.notifyContainerFailure(stackTrace));
  }

  @Override
  public void notifySuiteStart(String suite, int numberOfTests) {
    runEventListeners.forEach(l -> l.notifySuiteStart(suite, numberOfTests));
  }

  @Override
  public void notifyBeforeSuiteStart(String name) {
    runEventListeners.forEach(l -> l.notifyBeforeSuiteStart(name));
  }

  @Override
  public void notifyBeforeSuiteEnd(String name, String stackTrace, TestStatus status) {
    runEventListeners.forEach(l -> l.notifyBeforeSuiteEnd(name, stackTrace, status));
  }

  @Override
  public void notifyTestStart(String name, String description) {
    runEventListeners.forEach(l -> l.notifyTestStart(name, description));
  }

  @Override
  public void notifyTestEnd(String name, String stackTrace, TestStatus status, long elapsedTime) {
    runEventListeners.forEach(l -> l.notifyTestEnd(name, stackTrace, status, elapsedTime));
  }

  @Override
  public void notifyAfterSuiteStart(String name) {
    runEventListeners.forEach(l -> l.notifyAfterSuiteStart(name));
  }

  @Override
  public void notifyAfterSuiteEnd(String name, String stackTrace, TestStatus status) {
    runEventListeners.forEach(l -> l.notifyAfterSuiteEnd(name, stackTrace, status));
  }

  @Override
  public void notifySuiteEnd(String suite, long elapsedTime) {
    runEventListeners.forEach(l -> l.notifySuiteEnd(suite, elapsedTime));
  }

  @Override
  public void notifyCoverageReport(String coverageReportJson) {
    runEventListeners.forEach(l -> l.notifyCoverageReport(coverageReportJson));
  }

  @Override
  public void notifyRunFinish() {
    runEventListeners.forEach(RemoteRunEventListener::notifyRunFinish);
  }

  @Override
  public void notifyUnexpectedError(String stackTrace) {
    runEventListeners.forEach(l -> l.notifyUnexpectedError(stackTrace));
  }

  @Override
  public void notifySuiteUnexpectedError(String name, String stackTrace) {
    runEventListeners.forEach(l -> l.notifySuiteUnexpectedError(name, stackTrace));
  }

  public void addNotificationListener(RunEventListener listener) {
    runEventListeners.add(listener);
  }
}
