/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.event;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.activation.DataHandler;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.api.message.GroupCorrelation;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.connector.ReplyToHandler;
import org.mule.runtime.core.privileged.event.DefaultMuleSession;
import org.mule.runtime.core.privileged.event.MuleSession;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;

public class EventBuilder {
    private PrivilegedEvent.Builder muleEventBuilder;
    private InternalMessage.Builder muleMessageBuilder;
    private MuleSession session;

    private EventContext createEventContext(ComponentLocation location) {
        String id = UUID.randomUUID().toString();
        String serverId = UUID.randomUUID() + "-munit";
        return EventContextFactory.create((String)id, (String)serverId, (ComponentLocation)location, (FlowExceptionHandler)NullExceptionHandler.getInstance());
    }

    public EventBuilder(ComponentLocation location) {
        this.muleEventBuilder = PrivilegedEvent.builder((EventContext)this.createEventContext(location));
        this.muleMessageBuilder = InternalMessage.builder().nullValue();
        this.session = new DefaultMuleSession();
    }

    public EventBuilder(EventContext eventContext) {
        this.muleEventBuilder = PrivilegedEvent.builder((EventContext)eventContext);
        this.muleMessageBuilder = InternalMessage.builder().nullValue();
        this.session = new DefaultMuleSession();
    }

    public EventBuilder(Event originalEvent) {
        this.muleEventBuilder = PrivilegedEvent.builder((CoreEvent)((InternalEvent)originalEvent));
        this.muleMessageBuilder = InternalMessage.builder((Message)originalEvent.getMessage());
        this.session = new DefaultMuleSession(((InternalEvent)originalEvent).getSession());
    }

    public EventBuilder withPayload(Object payload) {
        this.muleMessageBuilder = this.muleMessageBuilder.value(payload);
        return this;
    }

    public EventBuilder withMediaType(MediaType mediaType) {
        this.muleMessageBuilder = this.muleMessageBuilder.mediaType(mediaType);
        return this;
    }

    public EventBuilder withAttributes(Object attributes) {
        this.muleMessageBuilder = this.muleMessageBuilder.attributesValue(attributes);
        return this;
    }

    public EventBuilder addVariable(String key, Object value) {
        this.muleEventBuilder = this.muleEventBuilder.addVariable(key, value);
        return this;
    }

    public EventBuilder addVariable(String key, Object value, String mediaType, String charset) {
        this.muleEventBuilder = this.muleEventBuilder.addVariable(key, value, this.buildDataType(value, mediaType, charset));
        return this;
    }

    public EventBuilder withVariables(Map<String, Object> variables) {
        this.muleEventBuilder = this.muleEventBuilder.variables(variables);
        return this;
    }

    public EventBuilder addSessionProperty(String key, Object value) {
        this.session.setProperty(key, value);
        return this;
    }

    public EventBuilder addSessionProperty(String key, Object value, String mediaType, String charset) {
        this.session.setProperty(key, value, this.buildDataType(value, mediaType, charset));
        return this;
    }

    public EventBuilder withSessionProperties(Map<String, TypedValue<Serializable>> sessionProperties) {
        Objects.requireNonNull(sessionProperties);
        sessionProperties.entrySet().forEach(entry -> this.session.setProperty((String)entry.getKey(), (Serializable)((TypedValue)entry.getValue()).getValue(), ((TypedValue)entry.getValue()).getDataType()));
        return this;
    }

    public EventBuilder clearSessionProperties() {
        this.session.clearProperties();
        return this;
    }

    public EventBuilder addInboundProperty(String key, Serializable value) {
        this.muleMessageBuilder = this.muleMessageBuilder.addInboundProperty(key, value);
        return this;
    }

    public EventBuilder addInboundProperty(String key, Serializable value, String mediaType, String charset) {
        this.muleMessageBuilder = this.muleMessageBuilder.addInboundProperty(key, value, this.buildDataType(value, mediaType, charset));
        return this;
    }

    public EventBuilder withInboundProperties(Map<String, Serializable> inboundProperties) {
        this.muleMessageBuilder = this.muleMessageBuilder.inboundProperties(inboundProperties);
        return this;
    }

    public EventBuilder addOutboundProperty(String key, Serializable value) {
        this.muleMessageBuilder = this.muleMessageBuilder.addOutboundProperty(key, value);
        return this;
    }

    public EventBuilder addOutboundProperty(String key, Serializable value, String mediaType, String charset) {
        this.muleMessageBuilder = this.muleMessageBuilder.addOutboundProperty(key, value, this.buildDataType(value, mediaType, charset));
        return this;
    }

    public EventBuilder withOutboundProperties(Map<String, Serializable> outboundProperties) {
        this.muleMessageBuilder = this.muleMessageBuilder.outboundProperties(outboundProperties);
        return this;
    }

    public EventBuilder addOutboundAttachment(String key, DataHandler value) {
        this.muleMessageBuilder = this.muleMessageBuilder.addOutboundAttachment(key, value);
        return this;
    }

    public EventBuilder withOutboundAttachments(Map<String, DataHandler> outboundAttachments) {
        this.muleMessageBuilder = this.muleMessageBuilder.outboundAttachments(outboundAttachments);
        return this;
    }

    public EventBuilder addInboundAttachment(String key, DataHandler value) {
        this.muleMessageBuilder = this.muleMessageBuilder.addInboundAttachment(key, value);
        return this;
    }

    public EventBuilder withInboundAttachments(Map<String, DataHandler> inboundAttachments) {
        this.muleMessageBuilder = this.muleMessageBuilder.inboundAttachments(inboundAttachments);
        return this;
    }

    public EventBuilder withSourceCorrelationId(String sourceCorrelationId) {
        this.muleEventBuilder = this.muleEventBuilder.correlationId(sourceCorrelationId);
        return this;
    }

    public EventBuilder withGroupCorrelation(GroupCorrelation correlation) {
        this.muleEventBuilder = this.muleEventBuilder.groupCorrelation(Optional.ofNullable(correlation));
        return this;
    }

    public EventBuilder withReplyToHandler(ReplyToHandler replyToHandler) {
        this.muleEventBuilder = this.muleEventBuilder.replyToHandler(replyToHandler);
        return this;
    }

    public EventBuilder withError(ErrorType errorType, Throwable exception) {
        ErrorBuilder errorBuilder = ErrorBuilder.builder();
        errorBuilder.errorType(errorType).description(exception.getMessage()).detailedDescription(exception.getMessage()).exception(exception);
        this.muleEventBuilder = this.muleEventBuilder.error(errorBuilder.build());
        return this;
    }

    public Event build() {
        return this.muleEventBuilder.message((Message)this.muleMessageBuilder.build()).session(this.session).build();
    }

    private DataType buildDataType(Object value, String mediaType, String charset) {
        return DataType.builder().fromObject(value).mediaType(mediaType).charset(charset).build();
    }
}

