/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.protocol.notifiers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.message.RunMessage;
import org.mule.munit.common.protocol.message.TestStatus;

public abstract class RunMessageNotifier
implements RunEventListener {
    protected String runToken;
    private Gson gson = new Gson();

    public abstract void init() throws Exception;

    public void setRunToken(String runToken) {
        this.runToken = runToken;
    }

    @Override
    public void notifyRunStart() {
        this.sendMessage(12, Collections.emptyMap());
    }

    @Override
    public void notifySuiteStart(String path, int numberOfTests) {
        this.sendMessage(1, (Map<String, String>)ImmutableMap.of((Object)"munitSuite", (Object)path, (Object)"numberOfTests", (Object)String.valueOf(numberOfTests)));
    }

    @Override
    public void notifyContainerFailure(String stackTrace) {
        this.sendMessage(2, (Map<String, String>)ImmutableMap.of((Object)"stackTrace", (Object)stackTrace));
    }

    @Override
    public void notifyBeforeSuiteStart(String name) {
        this.sendMessage(3, (Map<String, String>)ImmutableMap.of((Object)"name", (Object)name));
    }

    @Override
    public void notifyBeforeSuiteEnd(String name, String stackTrace, TestStatus status) {
        this.sendMessage(4, (Map<String, String>)ImmutableMap.of((Object)"name", (Object)name, (Object)"stackTrace", (Object)stackTrace, (Object)"status", (Object)status.toString()));
    }

    @Override
    public void notifyTestStart(String name, String description) {
        this.sendMessage(5, (Map<String, String>)ImmutableMap.of((Object)"name", (Object)name, (Object)"description", (Object)description));
    }

    @Override
    public void notifyTestEnd(String name, String stackTrace, TestStatus status, long elapsedTime) {
        this.sendMessage(6, (Map<String, String>)ImmutableMap.of((Object)"name", (Object)name, (Object)"stackTrace", (Object)stackTrace, (Object)"elapsedTime", (Object)String.valueOf(elapsedTime), (Object)"status", (Object)status.toString()));
    }

    @Override
    public void notifyAfterSuiteStart(String name) {
        this.sendMessage(7, (Map<String, String>)ImmutableMap.of((Object)"name", (Object)name));
    }

    @Override
    public void notifyAfterSuiteEnd(String name, String stackTrace, TestStatus status) {
        this.sendMessage(8, (Map<String, String>)ImmutableMap.of((Object)"name", (Object)name, (Object)"stackTrace", (Object)stackTrace, (Object)"status", (Object)status.toString()));
    }

    @Override
    public void notifySuiteEnd(String suite, long elapsedTime) {
        this.sendMessage(9, (Map<String, String>)ImmutableMap.of((Object)"munitSuite", (Object)suite, (Object)"elapsedTime", (Object)String.valueOf(elapsedTime)));
    }

    @Override
    public void notifyCoverageReport(String coverageReportJson) {
        this.sendMessage(10, (Map<String, String>)ImmutableMap.of((Object)"coverageReport", (Object)coverageReportJson));
    }

    @Override
    public void notifyRunFinish() {
        this.sendMessage(11, Collections.emptyMap());
    }

    @Override
    public void notifyUnexpectedError(String stackTrace) {
        this.sendMessage(99, (Map<String, String>)ImmutableMap.of((Object)"stackTrace", (Object)stackTrace));
    }

    @Override
    public void notifySuiteUnexpectedError(String name, String stackTrace) {
        this.sendMessage(98, (Map<String, String>)ImmutableMap.of((Object)"name", (Object)name, (Object)"stackTrace", (Object)stackTrace));
    }

    private void sendMessage(Integer id, Map<String, String> parameters) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.runToken), (Object)"runToken must not be null nor empty");
        HashMap<String, String> completeParams = new HashMap<String, String>();
        completeParams.put("runToken", this.runToken);
        completeParams.putAll(parameters);
        this.sendMessage(this.gson.toJson((Object)new RunMessage(id, completeParams)));
    }

    public abstract void sendMessage(String var1);
}

