/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.model;

import java.util.List;

import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;


/**
 * <p>
 * Represent the absence of an Error in an event
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class NullError implements Error {

  @Override
  public String getDescription() {
    return null;
  }

  @Override
  public String getDetailedDescription() {
    return null;
  }

  @Override
  public ErrorType getErrorType() {
    return null;
  }

  @Override
  public Throwable getCause() {
    return null;
  }

  @Override
  public Message getErrorMessage() {
    return null;
  }

  @Override
  public List<Error> getChildErrors() {
    return null;
  }

  @Override
  public boolean equals(Object object) {
    return object instanceof NullError;
  }

  @Override
  public int hashCode() {
    return 0;
  }
}
