/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.model.stereotype;

import static org.mule.munit.common.model.stereotype.MUnitStereotypes.MUNIT_TEST_PROCESSOR_DEFINITION;

import org.mule.runtime.extension.api.stereotype.StereotypeDefinition;

import java.util.Optional;

/**
 * Stereotypes for mock operations used in tests
 * 
 * @author Mulesoft Inc.
 * @since 2.4
 */
public class MUnitMockStereotype extends MUnitToolsStereotypeDefinition {

  @Override
  public String getName() {
    return "MUNIT_MOCK";
  }

  @Override
  public Optional<StereotypeDefinition> getParent() {
    return Optional.of(MUNIT_TEST_PROCESSOR_DEFINITION);
  }

}
