/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.mule.munit.common.util.IOUtils;

public class FileUtils
extends org.apache.commons.io.FileUtils {
    public static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    private static final SecureRandom random = new SecureRandom();

    public static String normalizeFilePath(URL url, String encoding) throws UnsupportedEncodingException {
        String resource = URLDecoder.decode(url.toExternalForm(), encoding);
        if (resource != null && resource.startsWith("file:/") && !(resource = resource.substring(6)).startsWith(File.separator)) {
            resource = File.separator + resource;
        }
        return resource;
    }

    public static void extractResources(String resourceName, Class callingClass, File outputDir, boolean keepParentDirectory) throws IOException {
        URL url = callingClass.getClassLoader().getResource(resourceName);
        URLConnection connection = url.openConnection();
        if (connection instanceof JarURLConnection) {
            FileUtils.extractJarResources((JarURLConnection)connection, outputDir, keepParentDirectory);
        } else {
            FileUtils.extractFileResources(FileUtils.normalizeFilePath(url, DEFAULT_ENCODING), outputDir, resourceName, keepParentDirectory);
        }
    }

    public static File findFileByName(File folder, final String filename, boolean recursive) {
        Collection<File> files = FileUtils.findFiles(folder, new IOFileFilter(){

            public boolean accept(File file) {
                return filename.equals(file.getName());
            }

            public boolean accept(File dir, String name) {
                return true;
            }
        }, recursive);
        return CollectionUtils.isEmpty(files) ? null : files.iterator().next();
    }

    public static String generateRandomFileName(String prefix, String suffix) {
        long n = random.nextLong();
        n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
        return prefix + Long.toString(n) + suffix;
    }

    public static boolean isInDirectory(File directory, File file) {
        if (Objects.isNull(directory) || !directory.isDirectory() || Objects.isNull(file)) {
            return false;
        }
        try {
            return file.getCanonicalPath().startsWith(directory.getCanonicalPath());
        }
        catch (IOException e) {
            return false;
        }
    }

    static boolean deleteTree(File dir) {
        return FileUtils.deleteTree(dir, null);
    }

    static boolean deleteTree(File dir, String[] topLevelDirsToIgnore) {
        if (dir == null || !dir.exists()) {
            return true;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            block0: for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    if (topLevelDirsToIgnore != null) {
                        for (int j = 0; j < topLevelDirsToIgnore.length; ++j) {
                            String ignored = topLevelDirsToIgnore[j];
                            if (ignored.equals(FilenameUtils.getBaseName((String)files[i].getName()))) continue block0;
                        }
                    }
                    if (FileUtils.deleteTree(files[i])) continue;
                    return false;
                }
                if (files[i].delete()) continue;
                return false;
            }
        }
        return dir.delete();
    }

    static File newFile(String pathName) {
        try {
            return new File(pathName).getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to create a canonical file for  %s", pathName), e);
        }
    }

    static File newFile(File parent, String child) {
        try {
            return new File(parent, child).getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create a canonical file for parent: " + parent + " and child: " + child, e);
        }
    }

    static File newFile(String parent, String child) {
        try {
            return new File(parent, child).getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create a canonical file for parent: " + parent + " and child: " + child, e);
        }
    }

    private static void extractFileResources(String path, File outputDir, String resourceName, boolean keepParentDirectory) throws IOException {
        File file = FileUtils.newFile(path);
        if (!file.exists()) {
            throw new IOException("The resource by path " + path + " ");
        }
        if (file.isDirectory()) {
            if (keepParentDirectory) {
                if (!(outputDir = FileUtils.newFile(outputDir.getPath() + File.separator + resourceName)).exists()) {
                    outputDir.mkdirs();
                }
            } else {
                outputDir = FileUtils.newFile(outputDir.getPath());
            }
            FileUtils.copyDirectory((File)file, (File)outputDir);
        } else {
            outputDir = keepParentDirectory ? FileUtils.newFile(outputDir.getPath() + File.separator + resourceName) : FileUtils.newFile(outputDir.getPath() + File.separator + file.getName());
            FileUtils.copyFile((File)file, (File)outputDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractJarResources(JarURLConnection connection, File outputDir, boolean keepParentDirectory) throws IOException {
        JarFile jarFile = connection.getJarFile();
        JarEntry jarResource = connection.getJarEntry();
        Enumeration<JarEntry> entries = jarFile.entries();
        InputStream inputStream = null;
        BufferedOutputStream outputStream = null;
        int jarResourceNameLenght = jarResource.getName().length();
        while (entries.hasMoreElements()) {
            File file;
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(jarResource.getName())) continue;
            String path = outputDir.getPath() + File.separator + entry.getName();
            if (!keepParentDirectory) {
                if (entry.isDirectory()) {
                    if (entry.getName().equals(jarResource.getName())) continue;
                    path = outputDir.getPath() + File.separator + entry.getName().substring(jarResourceNameLenght, entry.getName().length());
                } else {
                    path = entry.getName().length() > jarResourceNameLenght ? outputDir.getPath() + File.separator + entry.getName().substring(jarResourceNameLenght, entry.getName().length()) : outputDir.getPath() + File.separator + entry.getName().substring(entry.getName().lastIndexOf("/"), entry.getName().length());
                }
            }
            if (!(file = FileUtils.newFile(path)).getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException("Could not create directory: " + file.getParentFile());
            }
            if (entry.isDirectory()) {
                if (file.exists() || file.mkdirs()) continue;
                throw new IOException("Could not create directory: " + file);
            }
            try {
                inputStream = jarFile.getInputStream(entry);
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    private static Collection<File> findFiles(File folder, IOFileFilter filter, boolean recursive) {
        return FileUtils.listFiles((File)folder, (IOFileFilter)filter, (IOFileFilter)(recursive ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE));
    }
}

