/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.protocol.message;

import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Map;

/**
 * <p>
 * The Message that is serialized and sent when notifying run events
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class RunMessage implements Serializable {

  private static final long serialVersionUID = 42L;

  private Integer id;
  private Map<String, String> parameters;

  public RunMessage(Integer id, Map<String, String> parameters) {
    this.id = id;
    this.parameters = parameters;
  }

  public Integer getId() {
    return id;
  }

  public String get(String key) {
    return parameters.get(key);
  }

  public Integer getInt(String key) {
    return Integer.valueOf(get(key));
  }

  public Long getLong(String key) {
    return Long.valueOf(get(key));
  }

  public Double getDouble(String key) {
    return Double.valueOf(get(key));
  }

  public Boolean getBoolean(String key) {
    return Boolean.valueOf(get(key));
  }

  public TestStatus getStatus(String key) {
    return TestStatus.valueOf(StringUtils.upperCase(get(key)));
  }
}
