/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.exception;

import java.util.Optional;

/**
 * <p>
 * An Error thrown from the MUnit framework
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class MunitFail extends Error {

  private static final int MAX_CONTEXT_LENGTH = 20;
  private static final long serialVersionUID = 1L;

  public static void fail(String message) {
    throw Optional.ofNullable(message).map(AssertionError::new).orElseGet(AssertionError::new);
  }

  private final String expected;
  private final String actual;

  public MunitFail(String message, String expected, String actual) {
    super(message);
    this.expected = expected;
    this.actual = actual;
  }

  @Override
  public String getMessage() {
    return new ComparisonCompactor(MAX_CONTEXT_LENGTH, expected, actual).compact(super.getMessage());
  }
}
