/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.util;

import static java.util.Arrays.asList;

import java.util.List;

import org.apache.commons.lang3.exception.ExceptionUtils;

/**
 * Finds available port numbers in a specified range.
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class StackTraceUtil {

  public static final String MUNIT_VERBOSE_EXCEPTIONS = "munit.verbose.exceptions";
  private static final int STACKTRACE_LIMIT = 1;

  /**
   * Gets the stacktrace of the given {@link Throwable} based on the verbosity configuration
   * 
   * @param throwable Throwable from where to get the stack trace
   * @return Stack trace with adjusted verbosity
   */
  public static String getStackTrace(Throwable throwable) {
    if (throwable instanceof AssertionError) {
      if (Boolean.parseBoolean(System.getProperty(MUNIT_VERBOSE_EXCEPTIONS))) {
        return ExceptionUtils.getStackTrace(throwable);
      } else {
        return decreaseStackTraceVerbosity(throwable);
      }
    } else {
      return ExceptionUtils.getStackTrace(throwable);
    }
  }

  private static String decreaseStackTraceVerbosity(Throwable throwable) {
    List<StackTraceElement> originalStackTrace = asList(throwable.getStackTrace());
    throwable.setStackTrace(originalStackTrace.stream().limit(STACKTRACE_LIMIT).toArray(StackTraceElement[]::new));
    return ExceptionUtils.getStackTrace(throwable);
  }
}
