/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.munit.common.util;

import java.util.Objects;
import java.util.function.Supplier;

/**
 * <p>
 * Utility class to validate Preconditions
 * </p>
 * @author Mulesoft Inc.
 */
public class Preconditions {

  public static void checkArgument(boolean condition, String message) {
    if (!condition) {
      throw new IllegalArgumentException(message);
    }
  }

  public static void checkArgument(boolean condition, Supplier<String> message) {
    if (!condition) {
      throw new IllegalArgumentException((String) message.get());
    }
  }

  public static void checkState(boolean condition, String message) {
    if (!condition) {
      throw new IllegalStateException(message);
    }
  }

  public static void checkState(boolean condition, Supplier<String> message) {
    if (!condition) {
      throw new IllegalStateException((String) message.get());
    }
  }

  public static <T> T checkNotNull(T reference, String errorMessage) {
    if (Objects.isNull(reference)) {
      throw new NullPointerException(errorMessage);
    } else {
      return reference;
    }
  }

  public static <T> T checkNotNull(T reference) {
    return checkNotNull(reference, "Value cannot be null");
  }

  private Preconditions() {}
}
