/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.extension.maven.api;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.munit.extension.maven.internal.generator.ApplicationMuleArtifactJsonGenerator;
import org.mule.munit.extension.maven.internal.generator.ApplicationPomGenerator;
import org.mule.munit.extension.maven.internal.generator.ExtensionApplicationStructureGenerator;
import org.mule.munit.extension.maven.internal.generator.SharedLibrariesPluginPomEnricher;
import org.mule.munit.extension.maven.internal.locator.ExportedPackagesLocator;
import org.mule.munit.extension.maven.internal.locator.ExportedResourcesLocator;
import org.mule.munit.plugin.maven.AbstractMunitMojo;
import org.mule.munit.plugin.maven.TargetRuntime;
import org.mule.munit.plugin.maven.locators.TestConfigFilesLocator;
import org.mule.munit.plugin.maven.util.BaseRunConfigurationFactory;
import org.mule.munit.plugin.maven.util.DefaultResultPrinterFactory;
import org.mule.munit.plugin.maven.util.ResultPrinterFactory;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.tools.api.classloader.model.SharedLibraryDependency;

@Mojo(name="test", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class ExtensionTestMojo
extends AbstractMunitMojo {
    protected static final String TEMPORAL_EXTENSION_MODEL_JSON = "temporal-extension-model.json";
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/mule-artifact/mule-artifact.json")
    protected File muleArtifactJsonFile;
    @Parameter(defaultValue="${project.basedir}/src/test/java")
    protected File testSourcesDirectory;
    @Parameter(defaultValue="${project.testResources}")
    protected List<Resource> testResources;
    @Parameter(property="shared.libraries")
    protected List<SharedLibraryDependency> sharedLibraries;
    @Parameter(property="mule.packager.version", defaultValue="3.1.0")
    protected String packagerVersion;
    @Parameter(property="targetRuntimes")
    protected List<String> targetRuntimes;
    protected ApplicationMuleArtifactJsonGenerator muleArtifactJsonGenerator;
    protected ApplicationPomGenerator applicationPomGenerator;
    private ExtensionModel extensionModel;

    protected void init() throws MojoExecutionException {
        this.muleArtifactJsonGenerator = new ApplicationMuleArtifactJsonGenerator(this.getConfigs(), this.getExportedResources(), this.getExportedPackages());
        this.extensionModel = this.getExtensionModel();
        this.applicationPomGenerator = new ApplicationPomGenerator(this.project, this.getSharedLibrariesEnricher(), this.pluginArtifactId);
        super.init();
    }

    protected Map<TargetRuntime, RunConfiguration> getRunConfigurations() throws MojoExecutionException {
        HashMap<TargetRuntime, RunConfiguration> runConfigurations = new HashMap<TargetRuntime, RunConfiguration>();
        if (this.targetRuntimes == null || this.targetRuntimes.isEmpty()) {
            TargetRuntime targetRuntime = new TargetRuntime(this.muleApplicationModelLoader.getRuntimeVersion(), this.muleApplicationModelLoader.getRuntimeProduct());
            runConfigurations.put(targetRuntime, this.createRunConfiguration(targetRuntime));
        } else {
            for (String targetRuntimeCoordinate : this.targetRuntimes) {
                TargetRuntime targetRuntime = TargetRuntime.parse((String)targetRuntimeCoordinate);
                runConfigurations.put(targetRuntime, this.createRunConfiguration(targetRuntime));
            }
        }
        return runConfigurations;
    }

    protected ResultPrinterFactory getResultPrinterFactory() {
        return new DefaultResultPrinterFactory(this.getLog()).withSurefireReports(Boolean.valueOf(this.enableSurefireReports), this.surefireReportsFolder, this.effectiveSystemProperties).withTestOutputReports(Boolean.valueOf(this.redirectTestOutputToFile), this.testOutputDirectory);
    }

    protected ExtensionApplicationStructureGenerator getApplicationStructureGenerator() throws MojoExecutionException {
        try {
            return new ExtensionApplicationStructureGenerator(this.buildDirectory.toPath(), this.project.getGroupId(), this.project.getArtifactId(), this.generatePomXml(), this.generatePomProperties(), this.generateMuleArtifactJson());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create application structure", (Exception)e);
        }
    }

    protected File getMuleApplicationJsonPath() {
        return this.muleArtifactJsonFile;
    }

    protected byte[] generateMuleArtifactJson() throws IOException {
        String muleArtifactJson = FileUtils.readFileToString((File)this.muleArtifactJsonFile, (Charset)Charset.defaultCharset());
        MuleApplicationModel originalMuleApplicationModel = (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(muleArtifactJson);
        MuleApplicationModel appMuleApplicationModel = this.muleArtifactJsonGenerator.generate(originalMuleApplicationModel);
        return new MuleApplicationModelJsonSerializer().serialize((AbstractMuleArtifactModel)appMuleApplicationModel).getBytes(Charset.defaultCharset());
    }

    protected byte[] generatePomXml() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new MavenXpp3Writer().write((OutputStream)byteArrayOutputStream, this.applicationPomGenerator.generate());
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generatePomProperties() throws IOException {
        Properties properties = new Properties();
        properties.setProperty("groupId", this.project.getGroupId());
        properties.setProperty("artifactId", this.project.getArtifactId());
        properties.setProperty("version", this.project.getVersion());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        properties.store(output, "Generated by " + this.pluginArtifactId);
        return output.toByteArray();
    }

    private RunConfiguration createRunConfiguration(TargetRuntime targetRuntime) throws MojoExecutionException {
        return new BaseRunConfigurationFactory(this.getLog(), this.munitTest, this.munitTags, Boolean.valueOf(this.skipAfterFailure), targetRuntime, this.workingDirectoryGenerator, this.munitTestsDirectory, this.project, this.session).create();
    }

    private Set<String> getConfigs() {
        return new TestConfigFilesLocator().locateFiles(this.munitTestsDirectory).stream().map(suiteFile -> this.munitTestsDirectory.toURI().relativize(suiteFile.toURI())).map(URI::getPath).collect(Collectors.toSet());
    }

    private Set<String> getExportedResources() {
        return this.testResources.stream().map(resource -> new ExportedResourcesLocator(new File(resource.getDirectory())).locate()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<String> getExportedPackages() {
        return new ExportedPackagesLocator(this.testSourcesDirectory).locate();
    }

    private SharedLibrariesPluginPomEnricher getSharedLibrariesEnricher() throws MojoExecutionException {
        return new SharedLibrariesPluginPomEnricher(this.getExtensionModel(), this.getSharedLibraries(), this.packagerVersion);
    }

    private List<SharedLibraryDependency> getSharedLibraries() {
        return this.sharedLibraries == null ? Collections.emptyList() : this.sharedLibraries;
    }

    protected ExtensionModel getExtensionModel() throws MojoExecutionException {
        if (this.extensionModel == null) {
            File generatedExtensionModelFile = new File(this.buildDirectory, TEMPORAL_EXTENSION_MODEL_JSON);
            try {
                String serializedExModel = new String(Files.readAllBytes(generatedExtensionModelFile.toPath()), "UTF-8");
                this.extensionModel = new ExtensionModelJsonSerializer(true).deserialize(serializedExModel);
            }
            catch (Exception e) {
                throw new MojoExecutionException(String.format("Cannot obtain/read the file [%s] to deserialize the ExtensionModel", generatedExtensionModelFile.getAbsolutePath()), e);
            }
        }
        return this.extensionModel;
    }
}

