/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.extension.maven.internal.generator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;

public class ApplicationMuleArtifactJsonGenerator {
    protected static final String EXPORTED_RESOURCES = "exportedResources";
    protected static final String EXPORTED_PACKAGES = "exportedPackages";
    protected static final String INCLUDE_TEST_DEPENDENCIES = "includeTestDependencies";
    private Set<String> configs;
    private Set<String> exportedResources;
    private Set<String> exportedPackages;

    public ApplicationMuleArtifactJsonGenerator(Set<String> configs, Set<String> exportedResources, Set<String> exportedPackages) {
        this.configs = configs;
        this.exportedResources = exportedResources;
        this.exportedPackages = exportedPackages;
    }

    public MuleApplicationModel generate(MuleApplicationModel originalMuleApplicationModel) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = new MuleApplicationModel.MuleApplicationModelBuilder();
        builder.setConfigs(this.configs);
        builder.setMinMuleVersion(originalMuleApplicationModel.getMinMuleVersion());
        builder.setName(originalMuleApplicationModel.getName());
        builder.setRedeploymentEnabled(true);
        builder.setRequiredProduct(originalMuleApplicationModel.getRequiredProduct());
        builder.setSecureProperties(originalMuleApplicationModel.getSecureProperties());
        builder.withBundleDescriptorLoader(originalMuleApplicationModel.getBundleDescriptorLoader());
        builder.withClassLoaderModelDescriptorLoader(this.getClassLoaderModelLoaderDescriptor(originalMuleApplicationModel));
        return (MuleApplicationModel)builder.build();
    }

    private MuleArtifactLoaderDescriptor getClassLoaderModelLoaderDescriptor(MuleApplicationModel originalMuleApplicationModel) {
        MuleArtifactLoaderDescriptor descriptor = originalMuleApplicationModel.getClassLoaderModelLoaderDescriptor();
        HashMap<String, Object> newAttributes = new HashMap<String, Object>(descriptor.getAttributes());
        this.addAdditionalValues(newAttributes, EXPORTED_RESOURCES, this.exportedResources);
        this.addAdditionalValues(newAttributes, EXPORTED_PACKAGES, this.exportedPackages);
        newAttributes.put(INCLUDE_TEST_DEPENDENCIES, Boolean.TRUE.toString());
        return new MuleArtifactLoaderDescriptor(descriptor.getId(), newAttributes);
    }

    private void addAdditionalValues(Map<String, Object> attributes, String key, Set<String> additionalValues) {
        Collection originalEntries = attributes.getOrDefault(key, Collections.emptySet());
        HashSet<String> newEntries = new HashSet<String>(additionalValues);
        newEntries.addAll(originalEntries);
        attributes.put(key, newEntries);
    }
}

