/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.extension.maven.internal.generator;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.mule.munit.extension.maven.internal.generator.SharedLibrariesPluginPomEnricher;

public class ApplicationPomGenerator {
    protected static final String APPLICATION_PACKAGING = "mule-application";
    protected static final String MULE_PLUGIN_CLASSIFIER = "mule-plugin";
    protected static final String EXTENSION_DEPENDENCY_SCOPE = "system";
    protected static final String MODEL_VERSION = "4.0.0";
    public static final String TEST_SCOPE = "test";
    private static final List<String> APP_INCLUDED_SCOPES = Arrays.asList("test");
    private static final List<DependencyExclusion> BLACKLISTED_DEPENDENCIES = Arrays.asList(new DependencyExclusion("org.mule.tests.plugin", "mule-tests-component-plugin"));
    private final SharedLibrariesPluginPomEnricher sharedLibsPluginGenerator;
    private MavenProject project;
    private String pluginArtifactId;
    private Model pomModel;

    public ApplicationPomGenerator(MavenProject project, SharedLibrariesPluginPomEnricher sharedLibrariesEnricher, String pluginArtifactId) {
        this.project = project;
        this.pluginArtifactId = pluginArtifactId;
        this.pomModel = new Model();
        this.sharedLibsPluginGenerator = sharedLibrariesEnricher;
    }

    public Model generate() {
        this.setGeneralAttributes();
        this.addDependencies();
        this.addSharedLibraries();
        return this.pomModel;
    }

    private void setGeneralAttributes() {
        this.pomModel.setGroupId(this.project.getGroupId());
        this.pomModel.setArtifactId(this.project.getArtifactId());
        this.pomModel.setVersion(this.project.getVersion());
        this.pomModel.setPackaging(APPLICATION_PACKAGING);
        this.pomModel.setModelVersion(MODEL_VERSION);
    }

    private void addDependencies() {
        this.addMUnitPluginDependencies();
        this.addExtensionAsDependency();
        this.addFilteredDependencies();
    }

    private void addMUnitPluginDependencies() {
        Plugin munitPlugin = this.project.getBuild().getPlugins().stream().filter(p -> p.getArtifactId().equals(this.pluginArtifactId)).findAny().orElseThrow(() -> new IllegalStateException("No [" + this.pluginArtifactId + "] defined in the extension pom.xml"));
        List dependencies = munitPlugin.getDependencies();
        if (dependencies != null) {
            dependencies.forEach(dependency -> {
                dependency.setScope(TEST_SCOPE);
                this.pomModel.addDependency(dependency);
            });
        }
    }

    private void addExtensionAsDependency() {
        Dependency dependency = new Dependency();
        dependency.setGroupId(this.project.getGroupId());
        dependency.setArtifactId(this.project.getArtifactId());
        dependency.setVersion(this.project.getVersion());
        dependency.setSystemPath(this.getExtensionJarPath());
        dependency.setScope(EXTENSION_DEPENDENCY_SCOPE);
        dependency.setClassifier(MULE_PLUGIN_CLASSIFIER);
        this.pomModel.addDependency(dependency);
    }

    private String getExtensionJarPath() {
        String buildDir = this.project.getBuild().getDirectory();
        String path = buildDir + "/" + this.project.getArtifactId() + "-" + this.project.getVersion() + "-" + MULE_PLUGIN_CLASSIFIER + ".jar";
        if (!new File(path).exists()) {
            throw new IllegalStateException("Could not find module jar file, [" + path + "] does not exist.");
        }
        return path;
    }

    private void addSharedLibraries() {
        this.sharedLibsPluginGenerator.generate(this.pomModel, this.project.getDependencies());
    }

    private void addFilteredDependencies() {
        this.project.getDependencies().stream().filter(dependency -> APP_INCLUDED_SCOPES.contains(dependency.getScope())).filter(this::isNotBlacklisted).forEach(dependency -> this.pomModel.addDependency(dependency));
    }

    private boolean isNotBlacklisted(Dependency dependency) {
        return BLACKLISTED_DEPENDENCIES.stream().noneMatch(exclusion -> exclusion.excludes(dependency));
    }

    private static class DependencyExclusion {
        private String groupId;
        private String artifactId;

        DependencyExclusion(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        boolean excludes(Dependency dependency) {
            return this.groupId.equals(dependency.getGroupId()) && this.artifactId.equals(dependency.getArtifactId());
        }
    }
}

