/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.extension.maven.internal.generator;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.remote.api.project.ApplicationStructureGenerator;
import org.mule.tools.api.packager.archiver.MuleExplodedArchiver;

public class ExtensionApplicationStructureGenerator
implements ApplicationStructureGenerator {
    private static final String[] CLASSES_EXCLUSIONS = new String[]{FolderNames.META_INF.value() + File.separator + FolderNames.MULE_ARTIFACT.value() + File.separator + "mule-artifact.json"};
    private Path originFolder;
    private byte[] pomXmlContent;
    private byte[] pomPropertiesContent;
    private byte[] muleArtifactJson;
    private String groupId;
    private String artifactId;
    private File tempDir;

    public ExtensionApplicationStructureGenerator(Path originFolder, String groupId, String artifactId, byte[] pomXmlContent, byte[] pomPropertiesContent, byte[] muleArtifactJsonContent) {
        Preconditions.checkArgument((originFolder != null ? 1 : 0) != 0, (Object)"Origin folder cannot be null");
        Preconditions.checkArgument((boolean)originFolder.toFile().exists(), (Object)"Origin folder should exist");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)groupId), (Object)"Group Id cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)artifactId), (Object)"Artifact Id cannot be blank");
        Preconditions.checkArgument((pomXmlContent != null ? 1 : 0) != 0, (Object)"Pom file content cannot be null");
        Preconditions.checkArgument((pomPropertiesContent != null ? 1 : 0) != 0, (Object)"Pom properties content cannot be null");
        Preconditions.checkArgument((muleArtifactJsonContent != null ? 1 : 0) != 0, (Object)"Mule Artifact Json content cannot be null");
        this.originFolder = originFolder;
        this.pomXmlContent = pomXmlContent;
        this.pomPropertiesContent = pomPropertiesContent;
        this.muleArtifactJson = muleArtifactJsonContent;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.tempDir = Files.createTempDir();
    }

    public Path generate(Path destinationFolder) throws Exception {
        Preconditions.checkArgument((destinationFolder != null ? 1 : 0) != 0, (Object)"Destination folder cannot be null");
        MuleExplodedArchiver archiver = new MuleExplodedArchiver();
        this.addResources(archiver);
        this.addPomDescriptors(archiver);
        this.addMuleArtifactJson(archiver);
        archiver.setDestFile(destinationFolder.toFile());
        archiver.createArchive();
        FileUtils.cleanDirectory((File)this.tempDir);
        return destinationFolder;
    }

    private void addMuleArtifactJson(MuleExplodedArchiver archiver) throws IOException {
        File muleArtifactFolder = new File(this.tempDir, FolderNames.MULE_ARTIFACT.value());
        FileUtils.copyToFile((InputStream)new ByteArrayInputStream(this.muleArtifactJson), (File)new File(muleArtifactFolder, "mule-artifact.json"));
        archiver.addMuleArtifact(muleArtifactFolder, null, null);
    }

    private void addPomDescriptors(MuleExplodedArchiver archiver) throws IOException {
        File mavenFolder = new File(Files.createTempDir(), FolderNames.MAVEN.value());
        File groupIdFolder = new File(mavenFolder, this.groupId);
        File artifactIdFolder = new File(groupIdFolder, this.artifactId);
        FileUtils.copyToFile((InputStream)new ByteArrayInputStream(this.pomXmlContent), (File)new File(artifactIdFolder, "pom.xml"));
        FileUtils.copyToFile((InputStream)new ByteArrayInputStream(this.pomPropertiesContent), (File)new File(artifactIdFolder, "pom.properties"));
        archiver.addMaven(mavenFolder, null, null);
    }

    private void addResources(MuleExplodedArchiver archiver) {
        this.addToRootIfExists(archiver, this.originFolder.resolve(FolderNames.CLASSES.value()).toFile(), null, CLASSES_EXCLUSIONS);
        this.addToRootIfExists(archiver, this.originFolder.resolve(FolderNames.TEST_CLASSES.value()).toFile(), null, null);
        this.addToRootIfExists(archiver, this.originFolder.resolve(FolderNames.TEST_MULE.value()).resolve(FolderNames.MUNIT.value()).toFile(), null, null);
    }

    private void addToRootIfExists(MuleExplodedArchiver archiver, File file, String[] includes, String[] excludes) {
        if (file.exists()) {
            archiver.addToRoot(file, includes, excludes);
        }
    }
}

