/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.extension.maven.internal.generator;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.tools.api.classloader.model.SharedLibraryDependency;

public class SharedLibrariesPluginPomEnricher {
    public static final String MAVEN_TOOLS_GROUP_ID = "org.mule.tools.maven";
    public static final String MULE_MAVEN_PLUGIN_ARTIFACT_ID = "mule-maven-plugin";
    public static final String GROUP_ID = "groupId";
    public static final String ARTIFACT_ID = "artifactId";
    public static final String CONFIGURATION_ELEMENT = "configuration";
    public static final String SHARED_LIBRARY_ELEMENT = "sharedLibrary";
    public static final String SHARED_LIBRARIES_ELEMENT = "sharedLibraries";
    public static final String COMPILE_SCOPE = "compile";
    private final List<SharedLibraryDependency> parameterizedSharedLibraries;
    private final String packagerVersion;
    private final ExtensionModel extensionModel;

    public SharedLibrariesPluginPomEnricher(ExtensionModel extensionModel, List<SharedLibraryDependency> sharedLibraries, String packagerVersion) {
        this.extensionModel = extensionModel;
        this.packagerVersion = packagerVersion;
        this.parameterizedSharedLibraries = sharedLibraries;
    }

    public void generate(Model pomModel, List<Dependency> projectDependencies) {
        List<ExternalLibraryModel> externalLibs = this.getExternalLibs(this.extensionModel);
        if (externalLibs.isEmpty()) {
            return;
        }
        this.validateParameterizedLibraries(externalLibs);
        List<Dependency> sharedLibrariesDependencies = this.getSharedLibrariesDependencies(projectDependencies);
        this.addSharedLibrariesDependencies(sharedLibrariesDependencies, pomModel);
        Xpp3Dom sharedLibraries = this.createSharedLibrariesDeclarations(sharedLibrariesDependencies);
        Xpp3Dom configuration = this.createConfiguration(sharedLibraries);
        Plugin muleMavenPlugin = this.createPlugin(configuration);
        this.getBuildNode(pomModel).addPlugin(muleMavenPlugin);
    }

    private List<Dependency> getSharedLibrariesDependencies(List<Dependency> projectDependencies) {
        return projectDependencies.stream().filter(this::isDeclaredAsSharedLib).collect(Collectors.toList());
    }

    private void addSharedLibrariesDependencies(List<Dependency> sharedLibrariesDependencies, Model pomModel) {
        sharedLibrariesDependencies.stream().filter(sharedLibDep -> this.isNotAlreadyPresent(pomModel, (Dependency)sharedLibDep)).map(this::asCompileDependency).forEach(arg_0 -> ((Model)pomModel).addDependency(arg_0));
    }

    private boolean isNotAlreadyPresent(Model pomModel, Dependency sharedLibDependency) {
        return pomModel.getDependencies().stream().anyMatch(dep -> dep.getGroupId().equals(sharedLibDependency.getGroupId()) && dep.getArtifactId().equals(sharedLibDependency.getArtifactId()));
    }

    private Xpp3Dom createSharedLibrariesDeclarations(List<Dependency> sharedLibsDependencies) {
        Xpp3Dom sharedLibraries = new Xpp3Dom(SHARED_LIBRARIES_ELEMENT);
        sharedLibsDependencies.stream().filter(this::isDeclaredAsSharedLib).forEach(dependency -> sharedLibraries.addChild(this.createSharedLibraryDeclaration((Dependency)dependency)));
        return sharedLibraries;
    }

    private Xpp3Dom createConfiguration(Xpp3Dom sharedLibraries) {
        Xpp3Dom configuration = new Xpp3Dom(CONFIGURATION_ELEMENT);
        configuration.addChild(sharedLibraries);
        return configuration;
    }

    private Plugin createPlugin(Xpp3Dom configuration) {
        Plugin muleMavenPlugin = new Plugin();
        muleMavenPlugin.setGroupId(MAVEN_TOOLS_GROUP_ID);
        muleMavenPlugin.setArtifactId(MULE_MAVEN_PLUGIN_ARTIFACT_ID);
        muleMavenPlugin.setVersion(this.packagerVersion);
        muleMavenPlugin.setExtensions(true);
        muleMavenPlugin.setConfiguration((Object)configuration);
        return muleMavenPlugin;
    }

    private void validateParameterizedLibraries(List<ExternalLibraryModel> externalLibs) {
        List requiredLibs = externalLibs.stream().filter(l -> !l.isOptional()).map(ExternalLibraryModel::getName).collect(Collectors.toList());
        if (this.parameterizedSharedLibraries.size() < requiredLibs.size()) {
            StringBuilder sb = new StringBuilder().append("Missing SharedLibraries configuration. ").append("There are [").append(requiredLibs.size()).append("] required libraries ");
            if (this.parameterizedSharedLibraries.isEmpty()) {
                sb.append("but none was declared.");
            } else {
                sb.append("but only [").append(this.parameterizedSharedLibraries.size()).append("] ").append(this.parameterizedSharedLibraries.size() > 1 ? "were" : "was").append(" declared.");
            }
            sb.append("\n");
            sb.append("Required libraries are: ").append(requiredLibs).append(".");
            if (!this.parameterizedSharedLibraries.isEmpty()) {
                sb.append("\n").append("Provided libraries artifact-ids are: ").append(this.parameterizedSharedLibraries.stream().map(SharedLibraryDependency::getArtifactId).collect(Collectors.toList()));
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }

    private List<ExternalLibraryModel> getExternalLibs(ExtensionModel extensionModel) {
        final ImmutableList.Builder libs = ImmutableList.builder().addAll((Iterable)extensionModel.getExternalLibraryModels());
        new IdempotentExtensionWalker(){

            protected void onConnectionProvider(ConnectionProviderModel model) {
                libs.addAll((Iterable)model.getExternalLibraryModels());
            }

            protected void onConfiguration(ConfigurationModel model) {
                libs.addAll((Iterable)model.getExternalLibraryModels());
            }
        }.walk(extensionModel);
        return libs.build();
    }

    private Xpp3Dom createSharedLibraryDeclaration(Dependency dependency) {
        Xpp3Dom groupId = new Xpp3Dom(GROUP_ID);
        groupId.setValue(dependency.getGroupId());
        Xpp3Dom artifactId = new Xpp3Dom(ARTIFACT_ID);
        artifactId.setValue(dependency.getArtifactId());
        Xpp3Dom sharedLibrary = new Xpp3Dom(SHARED_LIBRARY_ELEMENT);
        sharedLibrary.addChild(groupId);
        sharedLibrary.addChild(artifactId);
        return sharedLibrary;
    }

    private boolean isDeclaredAsSharedLib(Dependency dep) {
        return this.parameterizedSharedLibraries.stream().anyMatch(lib -> lib.getGroupId().equals(dep.getGroupId()) && lib.getArtifactId().equals(dep.getArtifactId()));
    }

    private Build getBuildNode(Model pomModel) {
        Build build = pomModel.getBuild();
        if (pomModel.getBuild() == null) {
            build = new Build();
            pomModel.setBuild(build);
        }
        return build;
    }

    private Dependency asCompileDependency(Dependency dependency) {
        dependency.setScope(COMPILE_SCOPE);
        return dependency;
    }
}

