/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.extension.maven.internal.generator;

import static com.google.common.base.Preconditions.checkArgument;
import static java.lang.String.format;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

import java.nio.file.Path;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

import org.mule.tools.api.packager.archiver.MuleArchiver;

/**
 * Generates a Mule Application Jar with sources
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class MuleSourcesApplicationGenerator {

  private ExtensionApplicationStructureGenerator structureGenerator;
  private MavenProject mavenProject;
  private String projectName;

  public MuleSourcesApplicationGenerator(String projectName, MavenProject mavenProject,
                                         ExtensionApplicationStructureGenerator structureGenerator) {
    checkArgument(isNotBlank(projectName), "Project name cannot be blank");
    checkArgument(mavenProject != null, "Maven Project cannot be null");
    checkArgument(structureGenerator != null, "Structure generator cannot be null");
    this.structureGenerator = structureGenerator;
    this.mavenProject = mavenProject;
    this.projectName = projectName;
  }

  public void generate(Path location) throws MojoExecutionException {
    try {
      this.structureGenerator
          .withArchiver(new MuleArchiver())
          .withSourcesFolder(mavenProject.getBasedir())
          .generate(location.resolve(format("%s.jar", projectName)));
    } catch (Exception e) {
      throw new MojoExecutionException("Unable to generate application with sources", e);
    }
  }

}
