/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.extension.maven.internal.generator.maven;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.mule.munit.extension.maven.internal.generator.maven.PomEnricher;

public class ApplicationPomGenerator {
    protected static final String APPLICATION_PACKAGING = "mule-application";
    protected static final String MULE_PLUGIN_CLASSIFIER = "mule-plugin";
    protected static final String EXTENSION_DEPENDENCY_SCOPE = "system";
    protected static final String MODEL_VERSION = "4.0.0";
    protected static final String TEST_APPLICATION_SUFFIX = "-test-application";
    public static final String TEST_SCOPE = "test";
    private static final List<String> APP_INCLUDED_SCOPES = Arrays.asList("test");
    private static final List<DependencyExclusion> BLACKLISTED_DEPENDENCIES = Arrays.asList(new DependencyExclusion("org.mule.tests.plugin", "mule-tests-component-plugin"));
    private final List<PomEnricher> pomEnrichers;
    private String projectArtifactId;
    private MavenProject project;
    private String pluginArtifactId;

    public ApplicationPomGenerator(MavenProject project, List<PomEnricher> pomEnrichers, String projectArtifactId, String pluginArtifactId) {
        this.project = project;
        this.projectArtifactId = projectArtifactId;
        this.pluginArtifactId = pluginArtifactId;
        this.pomEnrichers = pomEnrichers;
    }

    public Model generate() {
        Model pomModel = new Model();
        this.setGeneralAttributes(pomModel);
        this.addDependencies(pomModel);
        this.addPomEnrichers(pomModel);
        return pomModel;
    }

    private void setGeneralAttributes(Model pomModel) {
        pomModel.setGroupId(this.project.getGroupId());
        pomModel.setArtifactId(this.projectArtifactId);
        pomModel.setVersion(this.project.getVersion());
        pomModel.setPackaging(APPLICATION_PACKAGING);
        pomModel.setModelVersion(MODEL_VERSION);
    }

    private void addDependencies(Model pomModel) {
        this.addMUnitPluginDependencies(pomModel);
        this.addExtensionAsDependency(pomModel);
        this.addFilteredDependencies(pomModel);
    }

    private void addMUnitPluginDependencies(Model pomModel) {
        Plugin munitPlugin = this.project.getBuild().getPlugins().stream().filter(p -> p.getArtifactId().equals(this.pluginArtifactId)).findAny().orElseThrow(() -> new IllegalStateException("No [" + this.pluginArtifactId + "] defined in the extension pom.xml"));
        List dependencies = munitPlugin.getDependencies();
        if (dependencies != null) {
            dependencies.forEach(dependency -> {
                Dependency newDependency = dependency.clone();
                newDependency.setScope(TEST_SCOPE);
                pomModel.addDependency(newDependency);
            });
        }
    }

    private void addExtensionAsDependency(Model pomModel) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(this.project.getGroupId());
        dependency.setArtifactId(this.project.getArtifactId());
        dependency.setVersion(this.project.getVersion());
        dependency.setSystemPath(this.getExtensionJarPath());
        dependency.setScope(EXTENSION_DEPENDENCY_SCOPE);
        dependency.setClassifier(MULE_PLUGIN_CLASSIFIER);
        pomModel.addDependency(dependency);
    }

    private String getExtensionJarPath() {
        String buildDir = this.project.getBuild().getDirectory();
        String path = buildDir + "/" + this.project.getArtifactId() + "-" + this.project.getVersion() + "-" + MULE_PLUGIN_CLASSIFIER + ".jar";
        if (!new File(path).exists()) {
            throw new IllegalStateException("Could not find module jar file, [" + path + "] does not exist.");
        }
        return path;
    }

    private void addPomEnrichers(Model pomModel) {
        this.pomEnrichers.forEach(pomEnricher -> pomEnricher.generate(pomModel));
    }

    private void addFilteredDependencies(Model pomModel) {
        this.project.getDependencies().stream().filter(dependency -> APP_INCLUDED_SCOPES.contains(dependency.getScope())).filter(this::isNotBlacklisted).forEach(arg_0 -> ((Model)pomModel).addDependency(arg_0));
    }

    private boolean isNotBlacklisted(Dependency dependency) {
        return BLACKLISTED_DEPENDENCIES.stream().noneMatch(exclusion -> exclusion.excludes(dependency));
    }

    private static class DependencyExclusion {
        private String groupId;
        private String artifactId;

        DependencyExclusion(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        boolean excludes(Dependency dependency) {
            return this.groupId.equals(dependency.getGroupId()) && this.artifactId.equals(dependency.getArtifactId());
        }
    }
}

