/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.extension.maven.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.extension.maven.api.DiscoverRuntimes;

public class RuntimeConfiguration {
    public static final String ADDITIONAL_RUNTIMES_PROPERTY = "additionalRuntimes";
    public static final String ADDITIONAL_RUNTIME_SEPARATOR = ",";
    private DiscoverRuntimes discoverRuntimes;
    private List<String> additionalRuntimes = Collections.emptyList();

    public RuntimeConfiguration() {
    }

    private RuntimeConfiguration(DiscoverRuntimes discoverRuntimes, List<String> additionalRuntimes) {
        this.discoverRuntimes = discoverRuntimes;
        this.additionalRuntimes = additionalRuntimes;
    }

    public Optional<DiscoverRuntimes> getDiscoverRuntimes() {
        return Optional.ofNullable(this.discoverRuntimes);
    }

    public List<String> getAdditionalRuntimes() {
        return this.additionalRuntimes;
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private DiscoverRuntimes discoverRuntimes;
        private List<String> additionalRuntimes = Collections.emptyList();

        Builder() {
        }

        Builder from(RuntimeConfiguration runtimeConfiguration) {
            if (runtimeConfiguration == null) {
                return this;
            }
            runtimeConfiguration.getDiscoverRuntimes().ifPresent(discRunt -> {
                this.discoverRuntimes = DiscoverRuntimes.builder().from((DiscoverRuntimes)discRunt).build();
            });
            this.additionalRuntimes = runtimeConfiguration.getAdditionalRuntimes();
            return this;
        }

        Builder withDiscoverRuntimes(DiscoverRuntimes discoverRuntimes) {
            this.discoverRuntimes = discoverRuntimes;
            return this;
        }

        Builder withAdditionalRuntimes(List<String> additionalRuntimes) {
            this.additionalRuntimes = additionalRuntimes;
            return this;
        }

        Builder withOverrides(Properties userProperties) {
            this.discoverRuntimes = DiscoverRuntimes.builder().from(this.discoverRuntimes).withOverrides(userProperties).build();
            if (userProperties.containsKey(RuntimeConfiguration.ADDITIONAL_RUNTIMES_PROPERTY)) {
                this.additionalRuntimes = Arrays.asList(StringUtils.split((String)userProperties.getProperty(RuntimeConfiguration.ADDITIONAL_RUNTIMES_PROPERTY), (String)RuntimeConfiguration.ADDITIONAL_RUNTIME_SEPARATOR));
            }
            return this;
        }

        RuntimeConfiguration build() {
            return new RuntimeConfiguration(this.discoverRuntimes, this.additionalRuntimes);
        }
    }
}

