/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.extension.maven.internal.locator;

import static com.google.common.base.Preconditions.checkArgument;
import static java.util.Collections.emptySet;

import java.io.File;
import java.net.URI;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.commons.io.FileUtils;

/**
 * Returns a set of all resources to export based on a folder
 * 
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class ExportedResourcesLocator {

  private File rootFolder;

  public ExportedResourcesLocator(File rootFolder) {
    checkArgument(rootFolder != null, "Resources folder cannot be null");
    this.rootFolder = rootFolder;
  }

  public Set<String> locate() {
    if (!rootFolder.exists()) {
      return emptySet();
    }
    return FileUtils
        .listFiles(rootFolder, null, true)
        .stream()
        .map(resourceFile -> rootFolder.toURI().relativize(resourceFile.toURI()))
        .map(URI::getPath)
        .collect(Collectors.toSet());
  }

}
