/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.extension.maven.internal.generator;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.mule.munit.extension.maven.internal.generator.maven.ApplicationPomGenerator;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.api.project.ApplicationStructureGenerator;
import org.mule.tools.api.packager.archiver.MuleArchiver;
import org.mule.tools.api.packager.archiver.MuleExplodedArchiver;
import org.mule.tools.api.packager.structure.FolderNames;

public class ExtensionApplicationStructureGenerator
implements ApplicationStructureGenerator {
    private Path originFolder;
    private ApplicationPomGenerator applicationPomGenerator;
    private byte[] pomPropertiesContent;
    private byte[] muleArtifactJson;
    private String groupId;
    private String artifactId;
    private File tempDir;
    private File sourcesFolder;
    private MuleArchiver archiver;

    public ExtensionApplicationStructureGenerator(Path originFolder, String groupId, String artifactId, ApplicationPomGenerator applicationPomGenerator, byte[] pomPropertiesContent, byte[] muleArtifactJsonContent) {
        Preconditions.checkArgument((originFolder != null ? 1 : 0) != 0, (Object)"Origin folder cannot be null");
        Preconditions.checkArgument((boolean)originFolder.toFile().exists(), (Object)"Origin folder should exist");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)groupId), (Object)"Group Id cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)artifactId), (Object)"Artifact Id cannot be blank");
        Preconditions.checkArgument((applicationPomGenerator != null ? 1 : 0) != 0, (Object)"Application pom generator cannot be null");
        Preconditions.checkArgument((pomPropertiesContent != null ? 1 : 0) != 0, (Object)"Pom properties content cannot be null");
        Preconditions.checkArgument((muleArtifactJsonContent != null ? 1 : 0) != 0, (Object)"Mule Artifact Json content cannot be null");
        this.originFolder = originFolder;
        this.applicationPomGenerator = applicationPomGenerator;
        this.pomPropertiesContent = pomPropertiesContent;
        this.muleArtifactJson = muleArtifactJsonContent;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.tempDir = Files.createTempDir();
        this.archiver = new MuleExplodedArchiver();
    }

    public ExtensionApplicationStructureGenerator withSourcesFolder(File sourcesFolder) {
        this.sourcesFolder = sourcesFolder;
        return this;
    }

    public ExtensionApplicationStructureGenerator withArchiver(MuleArchiver archiver) {
        this.archiver = archiver;
        return this;
    }

    public Path generate(Path destinationFolder, RunConfiguration runConfiguration) throws Exception {
        Preconditions.checkArgument((destinationFolder != null ? 1 : 0) != 0, (Object)"Destination folder cannot be null");
        byte[] pomXmlContent = this.generatePomXml(runConfiguration);
        this.addResources();
        this.addPomDescriptors(pomXmlContent);
        this.addMuleArtifactJson();
        if (Objects.nonNull(this.sourcesFolder)) {
            this.attachSources(pomXmlContent);
        }
        this.archiver.setDestFile(destinationFolder.toFile());
        this.archiver.createArchive();
        FileUtils.cleanDirectory((File)this.tempDir);
        return destinationFolder;
    }

    private void addMuleArtifactJson() throws IOException {
        File muleArtifactFolder = new File(this.tempDir, org.mule.munit.remote.FolderNames.MULE_ARTIFACT.value());
        FileUtils.copyToFile((InputStream)new ByteArrayInputStream(this.muleArtifactJson), (File)new File(muleArtifactFolder, "mule-artifact.json"));
        this.archiver.addMuleArtifact(muleArtifactFolder, null, null);
    }

    private void addPomDescriptors(byte[] pomXmlContent) throws IOException {
        File mavenFolder = new File(this.tempDir, org.mule.munit.remote.FolderNames.MAVEN.value());
        File groupIdFolder = new File(mavenFolder, this.groupId);
        File artifactIdFolder = new File(groupIdFolder, this.artifactId);
        FileUtils.copyToFile((InputStream)new ByteArrayInputStream(pomXmlContent), (File)new File(artifactIdFolder, "pom.xml"));
        FileUtils.copyToFile((InputStream)new ByteArrayInputStream(this.pomPropertiesContent), (File)new File(artifactIdFolder, "pom.properties"));
        this.archiver.addMaven(mavenFolder, null, null);
    }

    protected byte[] generatePomXml(RunConfiguration runConfiguration) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new MavenXpp3Writer().write((OutputStream)byteArrayOutputStream, this.applicationPomGenerator.generate(runConfiguration));
        return byteArrayOutputStream.toByteArray();
    }

    private void attachSources(byte[] pomXmlContent) throws IOException {
        File muleSources = new File(this.tempDir, FolderNames.MULE_SRC.value());
        File appSources = new File(muleSources, this.sourcesFolder.getName());
        FileUtils.copyDirectory((File)this.sourcesFolder, (File)appSources, path -> !path.equals(new File(this.sourcesFolder, FolderNames.TARGET.value())));
        FileUtils.copyToFile((InputStream)new ByteArrayInputStream(pomXmlContent), (File)new File(appSources, "pom.xml"));
        FileUtils.copyToFile((InputStream)new ByteArrayInputStream(this.muleArtifactJson), (File)new File(appSources, "mule-artifact.json"));
        String srcMainExclusion = Paths.get(this.sourcesFolder.getName(), new String[0]).resolve(FolderNames.SRC.value()).resolve(FolderNames.MAIN.value()).toString();
        this.archiver.addMuleSrc(muleSources, null, new String[]{srcMainExclusion + "/**"});
    }

    private void addResources() {
        this.addToRootIfExists(this.originFolder.resolve(org.mule.munit.remote.FolderNames.TEST_MULE.value()).resolve(org.mule.munit.remote.FolderNames.MUNIT.value()).toFile(), null, null);
        this.addToRootIfExists(this.originFolder.resolve(org.mule.munit.remote.FolderNames.TEST_CLASSES.value()).toFile(), null, null);
    }

    private void addToRootIfExists(File file, String[] includes, String[] excludes) {
        if (file.exists()) {
            this.archiver.addToRoot(file, includes, excludes);
        }
    }
}

