/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.extension.maven.internal.locator;

import static com.google.common.base.Preconditions.checkArgument;
import static java.util.Collections.emptySet;
import static java.util.Optional.ofNullable;
import static org.apache.commons.lang3.StringUtils.EMPTY;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.commons.io.FileUtils;

/**
 * Returns a set of all resources to export based on a folder
 * 
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class ExportedPackagesLocator {

  private File rootFolder;

  public ExportedPackagesLocator(File rootFolder) {
    checkArgument(rootFolder != null, "Resources folder cannot be null");
    this.rootFolder = rootFolder;
  }

  public Set<String> locate() {
    if (!rootFolder.exists()) {
      return emptySet();
    }
    return FileUtils
        .listFiles(rootFolder, null, true)
        .stream()
        .map(resourceFile -> rootFolder.toURI().relativize(resourceFile.toURI()))
        .map(this::getPackageFromFile)
        .collect(Collectors.toSet());
  }

  private String getPackageFromFile(URI classUri) {
    Path folderPath = new File(classUri.getPath()).toPath();
    return ofNullable(folderPath.getParent()).map(folder -> folder.toString().replace(File.separatorChar, '.')).orElse(EMPTY);
  }

}
