/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.extension.maven.internal.persistent;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.persistence.api.TypeAnnotationSerializerExtenderFallback;

import java.util.Optional;

/**
 * Fallback to avoid breaking deserialization of extension models from json if a type annotation has been added by SDK/Runtime
 * and it is not present on this classpath.
 *
 * @author Mulesoft Inc.
 * @since 1.1.0
 */
public class IgnoreMissingTypeAnnotationFallback implements TypeAnnotationSerializerExtenderFallback {

  @Override
  public Optional<Class<? extends TypeAnnotation>> fallbackFor(String s) {
    return Optional.empty();
  }
}
