/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.extension.maven.internal.generator.maven;

import java.io.File;

import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

/**
 * Generates the dependency definition for the extension (using System scope)
 *
 * @author Mulesoft Inc.
 * @since 1.1.0
 */
public class EmbeddedDependencyGenerator implements DependencyGenerator {

  protected static final String EXTENSION_DEPENDENCY_SCOPE = "system";
  protected static final String MULE_PLUGIN_CLASSIFIER = "mule-plugin";

  @Override
  public Dependency generateDependency(MavenProject project) {
    Dependency dependency = new Dependency();
    dependency.setGroupId(project.getGroupId());
    dependency.setArtifactId(project.getArtifactId());
    dependency.setVersion(project.getVersion());
    dependency.setSystemPath(getExtensionJarPath(project));
    dependency.setScope(EXTENSION_DEPENDENCY_SCOPE);
    dependency.setClassifier(MULE_PLUGIN_CLASSIFIER);

    return dependency;
  }

  /**
   * Looks for the extension jar file that follows the [${baseDirectory}/target/artifactId-version-classifier.jar] name
   * convention.
   *
   * @return the absolute path of the jar file, if exists.
   * @throws IllegalStateException if the extension jar file was not found.
   */
  private String getExtensionJarPath(MavenProject project) {
    String buildDir = project.getBuild().getDirectory();
    String path = buildDir + "/" + project.getArtifactId() + "-" + project.getVersion() + "-" + MULE_PLUGIN_CLASSIFIER + ".jar";
    if (!new File(path).exists()) {
      throw new IllegalStateException("Could not find module jar file, [" + path + "] does not exist.");
    }
    return path;
  }
}
