/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.extension.maven.internal.generator.maven;

import java.io.File;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.mule.munit.extension.maven.internal.generator.maven.DependencyGenerator;

public class EmbeddedDependencyGenerator
implements DependencyGenerator {
    protected static final String EXTENSION_DEPENDENCY_SCOPE = "system";
    protected static final String MULE_PLUGIN_CLASSIFIER = "mule-plugin";

    @Override
    public Dependency generateDependency(MavenProject project) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(project.getGroupId());
        dependency.setArtifactId(project.getArtifactId());
        dependency.setVersion(project.getVersion());
        dependency.setSystemPath(this.getExtensionJarPath(project));
        dependency.setScope(EXTENSION_DEPENDENCY_SCOPE);
        dependency.setClassifier(MULE_PLUGIN_CLASSIFIER);
        return dependency;
    }

    private String getExtensionJarPath(MavenProject project) {
        String buildDir = project.getBuild().getDirectory();
        String path = buildDir + "/" + project.getArtifactId() + "-" + project.getVersion() + "-" + MULE_PLUGIN_CLASSIFIER + ".jar";
        if (!new File(path).exists()) {
            throw new IllegalStateException("Could not find module jar file, [" + path + "] does not exist.");
        }
        return path;
    }
}

