/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.extension.maven.internal.generator;

import java.io.File;
import java.util.Optional;

import org.apache.maven.project.MavenProject;
import org.mule.tools.api.util.MavenComponents;
import org.mule.tools.api.util.SourcesProcessor;

/**
 * Generates the repository for the given {@link MavenComponents} in the provided location
 * 
 * @author Mulesoft Inc.
 * @since 1.1.0
 */
public class ApplicationRepositoryGenerator {

  private static final boolean LIGHTWEIGHT_PACKAGE = false;
  private static final boolean USE_LOCAL_REPOSITORY = true;
  private static final boolean TEST_PACKAGE = true;

  private final MavenComponents mavenComponents;
  private final MavenProject project;

  public ApplicationRepositoryGenerator(MavenComponents mavenComponents, MavenProject project) {
    this.mavenComponents = mavenComponents;
    this.project = project;
  }

  public void generateRepository(MavenProject mavenProject, File muleArtifact, File repositoryLocation) throws Exception {
    mavenComponents.withProject(mavenProject);
    SourcesProcessor processSources = new SourcesProcessor(mavenComponents);
    processSources.process(true, LIGHTWEIGHT_PACKAGE, USE_LOCAL_REPOSITORY, TEST_PACKAGE, repositoryLocation, muleArtifact,
                           Optional.of(new ExtensionMavenReactorResolver(project)));
  }
}
